---
name: innovation
description: Innovation management expertise for innovation frameworks (Design Thinking, Stage-Gate), ideation processes, innovation portfolio management, venture capital, open innovation, and IP strategy. Use when driving innovation, managing R&D portfolios, or building innovation programs.
---

# Innovation Expert

Comprehensive innovation frameworks for ideation, portfolio management, and innovation strategy.

## Innovation Strategy

### Innovation Horizons

```
THREE HORIZONS MODEL:

HORIZON 1 - CORE (70% of resources):
- Extend and defend core business
- Incremental improvements
- Process optimization
- Timeline: 0-2 years
- Risk: Low
- Returns: Known

HORIZON 2 - ADJACENT (20% of resources):
- Extend into new markets/products
- New capabilities
- Business model evolution
- Timeline: 2-5 years
- Risk: Medium
- Returns: Emerging

HORIZON 3 - TRANSFORMATIONAL (10% of resources):
- Create new businesses
- Disruptive innovation
- Emerging technologies
- Timeline: 5-10+ years
- Risk: High
- Returns: Uncertain
```

### Innovation Types

| Type            | Description              | Example                   |
| --------------- | ------------------------ | ------------------------- |
| **Incremental** | Improvements to existing | Product upgrades          |
| **Adjacent**    | New to company           | New market entry          |
| **Disruptive**  | New to industry          | Business model innovation |
| **Radical**     | New to world             | Breakthrough technology   |

### Innovation Portfolio

```
PORTFOLIO BALANCE:

BY TYPE:
- Core: 50-70%
- Adjacent: 20-30%
- Transformational: 10-20%

BY STAGE:
- Discovery: 40%
- Incubation: 30%
- Acceleration: 20%
- Scale: 10%

BY TIME HORIZON:
- Short-term (0-2 yr): 60%
- Medium-term (2-5 yr): 30%
- Long-term (5+ yr): 10%

PORTFOLIO METRICS:
- Pipeline value
- Stage conversion rates
- Time to market
- ROI by initiative
```

## Innovation Processes

### Design Thinking

```
DESIGN THINKING PHASES:

1. EMPATHIZE
- User research
- Observation
- Interviews
- Journey mapping
- Persona development

2. DEFINE
- Problem framing
- Point of view statement
- How might we questions
- Design principles

3. IDEATE
- Brainstorming
- Mind mapping
- Analogies
- Crazy 8s
- Concept selection

4. PROTOTYPE
- Low-fidelity mockups
- Paper prototypes
- Clickable wireframes
- Minimum viable product

5. TEST
- User testing
- Feedback collection
- Iteration
- Validation
```

See [Innovation Processes](./references/innovation-processes.md) for detailed Design Thinking methodology, Stage-Gate process, and Lean Startup enterprise adaptation.

### Stage-Gate Framework

```
STAGE-GATE MODEL:

GATE 1: Idea Screen → STAGE 1: Scoping
GATE 2: Second Screen → STAGE 2: Build Business Case
GATE 3: Decision to Develop → STAGE 3: Development
GATE 4: Decision to Test → STAGE 4: Testing & Validation
GATE 5: Launch Decision → STAGE 5: Launch

KEY GATES:
- Go/No-go decision points
- Criteria-based evaluation
- Resource allocation
- Risk assessment
```

See [Innovation Processes](./references/innovation-processes.md) for complete Stage-Gate details, gate criteria, and deliverables for each stage.

### Lean Startup in Enterprise

```
BUILD-MEASURE-LEARN:

BUILD:
- Minimum Viable Product (MVP)
- Experiment design
- Hypothesis formation
- Key assumptions

MEASURE:
- Validated learning
- Actionable metrics
- Split testing
- Customer feedback

LEARN:
- Pivot or persevere
- Insight generation
- Iteration planning
- Assumption validation

ENTERPRISE ADAPTATION:
- Innovation accounting
- Corporate sponsorship
- Governance integration
- Scale path definition
```

## Ideation & Selection

### Ideation Techniques

| Technique              | Best For           | Participants |
| ---------------------- | ------------------ | ------------ |
| **Brainstorming**      | Volume of ideas    | 5-10         |
| **Brainwriting**       | Equal contribution | 6-12         |
| **SCAMPER**            | Improving existing | 3-6          |
| **Analogies**          | Novel solutions    | 4-8          |
| **Reverse Brainstorm** | Problem avoidance  | 5-10         |
| **Design Sprint**      | Rapid prototyping  | 5-7          |

### Idea Evaluation

```
EVALUATION CRITERIA:

STRATEGIC FIT:
- Alignment with strategy
- Synergies with core business
- Brand consistency

MARKET POTENTIAL:
- Market size
- Growth potential
- Competitive advantage
- Customer need

TECHNICAL FEASIBILITY:
- Technical capability
- Resource availability
- Time to develop
- IP potential

FINANCIAL:
- Revenue potential
- Investment required
- Risk/return profile
- Payback period

SCORING MATRIX:
| Criteria | Weight | Score (1-5) | Weighted |
|----------|--------|-------------|----------|
| Strategic | 25% | | |
| Market | 30% | | |
| Technical | 25% | | |
| Financial | 20% | | |
| Total | 100% | | |
```

## Corporate Venture Capital

### CVC Strategy

```
CVC OBJECTIVES:

STRATEGIC:
- Window on technology
- Access to innovation
- Market intelligence
- Partnership pipeline
- Ecosystem influence

FINANCIAL:
- Return on investment
- Portfolio diversification
- Option value

OPERATING MODEL:
| Model | Focus | Structure |
|-------|-------|-----------|
| Direct | Strategic | Internal team |
| LP Commitment | Financial + Access | Fund investment |
| Hybrid | Balanced | Both approaches |

INVESTMENT CRITERIA:
- Strategic relevance
- Team quality
- Market opportunity
- Technology differentiation
- Stage fit
- Terms alignment
```

### CVC Best Practices

```
SUCCESS FACTORS:

GOVERNANCE:
- Clear mandate
- Decision rights
- Board representation
- Conflict management

INTEGRATION:
- Business unit sponsorship
- Commercial engagement
- Technology transfer
- Exit planning

PORTFOLIO:
- Diversification
- Stage balance
- Follow-on reserves
- Value-add services

METRICS:
- Financial return (IRR, MOIC)
- Strategic value realization
- Deal flow quality
- Portfolio company health
```

## Open Innovation

### Open Innovation Models

| Model             | Description            | Example                  |
| ----------------- | ---------------------- | ------------------------ |
| **Crowdsourcing** | Mass participation     | InnoCentive              |
| **Partnerships**  | Joint development      | Research collaborations  |
| **Licensing In**  | Technology acquisition | University tech transfer |
| **Licensing Out** | IP monetization        | Patent licensing         |
| **Spin-offs**     | New entities           | Internal ventures        |
| **Accelerators**  | Startup support        | Corporate accelerator    |

### External Innovation Program

```
PROGRAM COMPONENTS:

SCOUTING:
- Technology mapping
- Startup ecosystem
- Academic research
- Competitor monitoring

ENGAGEMENT:
- Partnership models
- Pilot programs
- Investment options
- Integration pathways

INTEGRATION:
- IP agreements
- Joint development
- Commercial terms
- Exit provisions

METRICS:
- Deals evaluated
- Partnerships formed
- Technologies adopted
- Value created
```

## Intellectual Property Strategy

### IP Portfolio Management

```
IP STRATEGY:

OFFENSIVE IP:
- Block competitors
- License revenue
- M&A leverage
- Market positioning

DEFENSIVE IP:
- Freedom to operate
- Litigation protection
- Cross-licensing
- Standard setting

PORTFOLIO DECISIONS:
- File vs. trade secret
- Geographic coverage
- Maintenance vs. abandonment
- Licensing strategy

IP METRICS:
- Patent grants/year
- Citation index
- License revenue
- Litigation success
```

See [IP Strategy](./references/ip-strategy.md) for detailed patent filing decisions, trade secret protection, licensing frameworks, and IP valuation methods.

### Patent Strategy

```
PATENT FILING DECISION:

FILE PATENT WHEN:
- Technology is novel
- Enforcement is practical
- Long commercial life
- Competitive blocking value
- Licensing potential

TRADE SECRET WHEN:
- Process-based innovation
- Difficult to reverse engineer
- Rapid evolution expected
- Enforcement challenges
- Cost constraints

GEOGRAPHIC FILING:
- Key markets
- Manufacturing locations
- Competitor locations
- Enforcement capability
```

## Innovation Metrics

### Innovation KPIs

| Category       | Metric              | Target             |
| -------------- | ------------------- | ------------------ |
| **Input**      | R&D as % of revenue | Industry benchmark |
| **Pipeline**   | Ideas in pipeline   | Growing            |
| **Process**    | Time to market      | Decreasing         |
| **Output**     | New product revenue | 20-30% of total    |
| **Efficiency** | R&D ROI             | > cost of capital  |

### Innovation Accounting

```
INNOVATION METRICS:

LEADING INDICATORS:
- Ideas submitted
- Experiments run
- Prototypes built
- Customer interviews

LAGGING INDICATORS:
- Products launched
- Revenue from new products
- Patents granted
- ROI achieved

LEARNING METRICS:
- Validated learnings
- Pivots completed
- Assumptions tested
- Time to learn
```

## Innovation Culture

### Culture Building

```
INNOVATION CULTURE ELEMENTS:

TOLERANCE FOR FAILURE:
- Safe to experiment
- Learning from failure
- No blame culture
- Celebrate smart failures

RISK-TAKING:
- Encourage experimentation
- Support calculated risks
- Resource allocation
- Executive backing

COLLABORATION:
- Cross-functional teams
- Open communication
- Knowledge sharing
- External partnerships

EMPOWERMENT:
- Autonomy
- Decision rights
- Resource access
- Recognition
```

### Innovation Programs

| Program              | Purpose          | Participants      |
| -------------------- | ---------------- | ----------------- |
| **Hackathons**       | Rapid ideation   | All employees     |
| **Innovation Labs**  | Deep exploration | Dedicated team    |
| **Intrapreneurship** | Venture building | Selected projects |
| **Idea Challenges**  | Problem solving  | Open submission   |
| **Learning Days**    | Skill building   | All employees     |

See [Innovation Processes](./references/innovation-processes.md) for detailed program formats, governance structures, and best practices.

## Additional Resources

For comprehensive innovation management frameworks:

- [Innovation Management Skill](./references/innovation-management-skill.md) - Complete innovation reference
- [Corporate Venture & Open Innovation](./references/corporate-venture-open-innovation-skill.md) - CVC and partnership strategies
- [Innovation Processes](./references/innovation-processes.md) - Design Thinking, Stage-Gate, Lean Startup details
- [IP Strategy](./references/ip-strategy.md) - Patent strategy, trade secrets, licensing

## See Also

- [R&D Management](../rd-management/SKILL.md) - Research portfolio management
- [Product Management](../product-management/SKILL.md) - Product strategy and roadmaps
- [Business Strategy](../business-strategy/SKILL.md) - Strategic planning
