# Intellectual Property Strategy

Comprehensive IP portfolio management, patent strategy, and licensing frameworks.

## IP Portfolio Management

### Strategic IP Framework

**Offensive IP Strategy:**

**Block Competitors:**

- Patent key technologies
- Cover design-arounds
- Build patent thickets
- Strategic geographic coverage

**License Revenue:**

- Identify licensable IP
- Market to non-competitors
- Standard essential patents
- Cross-licensing opportunities

**M&A Leverage:**

- Strengthen acquisition position
- Increase company valuation
- Due diligence advantage
- Integration synergies

**Market Positioning:**

- Thought leadership
- Innovation credibility
- Investor confidence
- Customer trust

**Defensive IP Strategy:**

**Freedom to Operate (FTO):**

- Pre-launch FTO searches
- Identify blocking patents
- Design-around strategies
- License or challenge

**Litigation Protection:**

- Build defensive portfolio
- Patent arms race
- Mutual assured destruction
- Litigation deterrence

**Cross-Licensing:**

- Portfolio swaps
- Reduce licensing costs
- Access to technologies
- Industry cooperation

**Standard Setting:**

- Participate in standards bodies
- Contribute to standards
- FRAND commitments
- Standard essential patents (SEPs)

### Portfolio Decisions

**File vs. Trade Secret:**

**File Patent When:**

- Technology is novel and non-obvious
- Enforcement is practical
- Long commercial life expected (10+ years)
- Competitive blocking value high
- Licensing potential exists
- Disclosure won't enable competitors significantly

**Keep as Trade Secret When:**

- Process-based innovation
- Difficult to reverse engineer
- Rapid evolution expected (< 5 years)
- Enforcement would be challenging
- Cost constraints
- Disclosure would harm competitive position

**Examples:**

- Patent: Device designs, algorithms, formulations
- Trade Secret: Manufacturing processes, customer lists, pricing algorithms

**Geographic Coverage:**

**Factors:**

- Key markets (revenue sources)
- Manufacturing locations
- Competitor locations
- Enforcement capability
- Budget constraints

**Typical Strategy:**

- PCT filing → 12 months → Select countries
- Priority countries: US, EU, China, Japan
- Secondary: India, Korea, Brazil, Australia
- Niche: Country-specific advantages

**Cost Considerations:**

- US patent: $10K-$30K
- Global coverage (10 countries): $100K-$300K over life
- Annual maintenance fees increase
- Quality over quantity

**Maintenance vs. Abandonment:**

**Maintain When:**

- Technology still relevant
- Licensing potential
- Blocking value
- Strategic importance
- Cost justified by value

**Abandon When:**

- Technology obsolete
- No licensing interest
- No blocking value
- Maintenance cost > benefit
- Strategic priorities changed

**Licensing Strategy:**

**Exclusive License:**

- Single licensee
- Higher royalty rates
- Limited market coverage
- Strong partner commitment

**Non-Exclusive License:**

- Multiple licensees
- Lower royalty rates
- Broader market coverage
- Revenue diversification

**Field-of-Use License:**

- Specific applications
- Enables multiple non-competing licenses
- Maximizes total revenue
- Example: Medical vs. industrial use

**Cross-License:**

- Mutual access
- Often royalty-free
- Strategic partnerships
- Risk reduction

## Patent Strategy

### Patent Filing Decision Tree

```
Is technology novel?
├─ No → Don't file
└─ Yes → Is it non-obvious?
    ├─ No → Don't file
    └─ Yes → Can competitors design around easily?
        ├─ Yes → File broad claims or don't file
        └─ No → Is enforcement practical?
            ├─ No → Consider trade secret
            └─ Yes → Does disclosure harm us?
                ├─ Yes → Trade secret
                └─ No → FILE PATENT
```

### Claim Strategy

**Claim Types:**

**Independent Claims:**

- Broadest protection
- Standalone
- Easier to invalidate
- Example: "A device comprising..."

**Dependent Claims:**

- Narrower scope
- Builds on independent
- Harder to invalidate
- Example: "The device of claim 1, wherein..."

**Best Practice:**

- 1-3 independent claims (broad)
- 10-20 dependent claims (narrower)
- Cover design-arounds
- Range from broad to specific

### Provisional vs. Non-Provisional

**Provisional Application:**

- Lower cost ($2K-$5K)
- 12-month priority date
- No examination
- Informal format
- Buys time to refine

**Non-Provisional Application:**

- Higher cost ($10K-$30K)
- Formal examination
- Can lead to grant
- Strict format requirements
- 20-year term from filing

**Strategy:**

- File provisional early
- Refine over 12 months
- Convert to non-provisional
- Iterate on claims

### International Patent Strategy

**PCT (Patent Cooperation Treaty):**

**Timeline:**

```
Month 0: File priority application (US)
Month 12: File PCT application
Month 18: International publication
Month 30-32: Enter national phase (select countries)
```

**Advantages:**

- 30-month decision window
- Single filing for 150+ countries
- International search report
- Defer costs

**Country Selection:**

**Tier 1 (Essential):**

- United States
- European Patent Office (EPO)
- China
- Japan

**Tier 2 (Strategic):**

- Korea
- Canada
- Australia
- India

**Tier 3 (Opportunistic):**

- Brazil
- Mexico
- Taiwan
- Israel

**Selection Criteria:**

- Market size
- Revenue potential
- Competitor presence
- Manufacturing location
- Enforcement capability
- Cost vs. benefit

## Trade Secrets

### Trade Secret Criteria (Uniform Trade Secrets Act)

1. **Information has economic value** from not being generally known
2. **Reasonable efforts** to maintain secrecy
3. **Not readily ascertainable** by proper means

### Protection Measures

**Legal:**

- Non-disclosure agreements (NDAs)
- Employment agreements
- Non-compete clauses (where legal)
- Confidentiality policies
- Visitor agreements

**Technical:**

- Access controls
- Encryption
- Need-to-know basis
- Segmented information
- Audit trails

**Physical:**

- Restricted areas
- Badge access
- Visitor logs
- Clean desk policy
- Secure disposal

**Organizational:**

- Employee training
- Exit interviews
- Offboarding procedures
- Third-party audits
- Incident response plan

### Examples by Industry

**Technology:**

- Source code
- Algorithms (if not patented)
- Customer data
- Pricing models

**Manufacturing:**

- Processes
- Formulations
- Quality control methods
- Supplier relationships

**Services:**

- Customer lists
- Pricing strategies
- Business methods
- Market analysis

## IP Valuation

### Valuation Methods

**Cost Approach:**

- Cost to recreate IP
- R&D investment
- Prosecution costs
- Minimum value

**Market Approach:**

- Comparable transactions
- Licensing agreements
- Auction results
- Market-based

**Income Approach:**

- Discounted cash flows
- Relief from royalty
- Excess earnings
- Most common for monetization

### Licensing Royalty Rates

**Industry Benchmarks:**

| Industry          | Typical Range |
| ----------------- | ------------- |
| Software          | 10-30%        |
| Pharmaceuticals   | 5-15%         |
| Electronics       | 1-5%          |
| Chemicals         | 3-10%         |
| Consumer Products | 3-10%         |

**Royalty Structure:**

**Running Royalty:**

- % of net sales
- Ongoing payments
- Tracks with success

**Lump Sum:**

- One-time payment
- Predictable
- No ongoing tracking

**Hybrid:**

- Upfront + running royalty
- Balances risk
- Common in pharma

**Milestone Payments:**

- Based on achievements
- Development milestones
- Sales milestones

## IP Metrics and KPIs

### Innovation Metrics

| Metric                  | Definition                  | Target           |
| ----------------------- | --------------------------- | ---------------- |
| **Patent Filings/Year** | New applications filed      | Trend increasing |
| **Grant Rate**          | % of applications granted   | 60-80%           |
| **Time to Grant**       | Months from filing to grant | < 36 months      |
| **Citation Index**      | Citations per patent        | > industry avg   |
| **Patent Strength**     | Claims allowed / filed      | > 0.7            |

### Commercial Metrics

| Metric                  | Definition                        | Target           |
| ----------------------- | --------------------------------- | ---------------- |
| **License Revenue**     | Annual licensing income           | Trend increasing |
| **Revenue/Patent**      | License revenue per patent        | > $50K/year      |
| **Coverage Ratio**      | Products covered / total products | > 80%            |
| **Enforcement Success** | Wins / total cases                | > 70%            |

### Portfolio Health

| Metric                   | Definition                  | Healthy Range         |
| ------------------------ | --------------------------- | --------------------- |
| **Portfolio Age**        | Average patent age          | 5-10 years            |
| **Active Patents**       | In-force / total            | > 80%                 |
| **Technology Diversity** | Technology areas covered    | Aligned with business |
| **Geographic Coverage**  | Countries per patent family | 5-10                  |

## IP Due Diligence (M&A)

### Due Diligence Checklist

**Ownership Verification:**

- [ ] Clear title to all IP
- [ ] Inventor assignments signed
- [ ] No third-party claims
- [ ] Employment agreements for IP
- [ ] Contractor agreements

**Patent Portfolio:**

- [ ] List of all patents and applications
- [ ] Status of each (pending, granted, expired)
- [ ] Maintenance fee status
- [ ] Prosecution history review
- [ ] Prior art search results
- [ ] Freedom to operate analysis

**Trade Secrets:**

- [ ] Inventory of trade secrets
- [ ] Protection measures documented
- [ ] NDA coverage
- [ ] Employee turnover risk
- [ ] Potential leaks

**Licenses:**

- [ ] In-licenses (what we license in)
- [ ] Out-licenses (what we license out)
- [ ] Terms and restrictions
- [ ] Change of control provisions
- [ ] Sublicensing rights

**Litigation:**

- [ ] Current litigation
- [ ] Past litigation (last 10 years)
- [ ] Potential disputes
- [ ] Opposition proceedings
- [ ] Settlement agreements

**Encumbrances:**

- [ ] Liens or security interests
- [ ] Joint ownership
- [ ] Government rights
- [ ] University rights
- [ ] Sponsored research agreements

### Red Flags

**Critical:**

- Unclear ownership
- Active litigation
- Material licenses expiring
- Government march-in rights
- Missing assignments

**Concerning:**

- High maintenance cost
- Narrow claims
- Weak enforcement history
- Concentrated in declining technology
- Low citation index

## IP Strategy by Business Model

### Product Companies

**Focus:**

- Broad product coverage
- Design-around protection
- Manufacturing process patents
- Brand protection (trademarks)

**Portfolio:**

- 70% patents
- 20% trade secrets
- 10% trademarks

### Platform Companies

**Focus:**

- Core platform patents
- Ecosystem protection
- API and interface patents
- Network effect protection

**Portfolio:**

- 60% patents
- 30% trade secrets
- 10% copyrights

### Service Companies

**Focus:**

- Business method patents
- Process innovations
- Customer relationships (trade secrets)
- Brand (trademarks)

**Portfolio:**

- 40% trade secrets
- 30% patents
- 30% trademarks

### Research Organizations

**Focus:**

- Fundamental technology
- Broad licensing potential
- High-quality patents
- Technology transfer

**Portfolio:**

- 80% patents
- 20% trade secrets
- Emphasis on licensing revenue
