---
name: startup-launch
description: Complete startup launch guidance from idea validation to market entry. Use when planning a new business, validating product ideas, or preparing for launch.
---

# Startup Launch

Comprehensive guide for launching a successful startup from idea to market.

## The Startup Journey

### Phase Overview

```
PHASE 1: IDEATION (1-2 weeks)
└─→ Problem identification, market research

PHASE 2: VALIDATION (2-4 weeks)
└─→ Customer discovery, problem-solution fit

PHASE 3: MVP DEVELOPMENT (4-12 weeks)
└─→ Minimum viable product, iteration

PHASE 4: LAUNCH PREPARATION (2-4 weeks)
└─→ Go-to-market strategy, pre-launch

PHASE 5: LAUNCH & ITERATE (Ongoing)
└─→ Public release, growth, optimization
```

---

## Phase 1: Ideation

### Problem Discovery

```
Ask yourself:
┌─────────────────────────────────────────┐
│ 1. What problem am I solving?           │
│ 2. Who has this problem?                │
│ 3. How painful is this problem?         │
│ 4. How are people solving it today?     │
│ 5. Why hasn't this been solved yet?     │
└─────────────────────────────────────────┘
```

### Problem Evaluation Matrix

| Criteria               | Score (1-5)                   | Notes        |
| ---------------------- | ----------------------------- | ------------ |
| **Frequency**          | How often does problem occur? | Daily = 5    |
| **Intensity**          | How painful is it?            | Critical = 5 |
| **Willingness to Pay** | Will people pay to solve?     | Yes = 5      |
| **Market Size**        | How many have this problem?   | Large = 5    |
| **Accessibility**      | Can you reach these people?   | Easy = 5     |

**Minimum viable score: 20/25**

### Idea Sources

```
HIGH-SIGNAL sources:
✓ Problems you personally experience
✓ Inefficiencies in your industry
✓ Complaints from friends/colleagues
✓ Existing solutions that frustrate users
✓ Emerging technology applications

LOW-SIGNAL sources:
✗ "Wouldn't it be cool if..."
✗ Building for imaginary users
✗ Copying without understanding
✗ Solutions looking for problems
```

---

## Phase 2: Validation

### Customer Discovery

```
The Mom Test Questions:
┌─────────────────────────────────────────┐
│ ✓ "Tell me about the last time you..."  │
│ ✓ "What have you tried to solve this?"  │
│ ✓ "How much does this cost you?"        │
│ ✓ "Who else should I talk to?"          │
├─────────────────────────────────────────┤
│ ✗ "Would you use this product?"         │
│ ✗ "Do you think this is a good idea?"   │
│ ✗ "How much would you pay?"             │
└─────────────────────────────────────────┘

Rule: Ask about their life, not your idea.
```

### Interview Framework

```
Structure (30-45 minutes):
1. Context (5 min)
   - Their role, situation
   - Relevant background

2. Problem Exploration (15 min)
   - Specific recent examples
   - Current workflow
   - Pain points and workarounds

3. Current Solutions (10 min)
   - Tools they use now
   - Satisfaction level
   - What's missing

4. Value (5 min)
   - Impact of solving this
   - Who else is affected
   - Budget/authority

5. Wrap-up (5 min)
   - Referrals
   - Follow-up permission
```

### Validation Metrics

| Signal                | Indicator           | Strength |
| --------------------- | ------------------- | -------- |
| **Time commitment**   | Agree to interview  | Low      |
| **Referrals**         | Introduce to others | Medium   |
| **Money commitment**  | Pre-order/deposit   | High     |
| **Work commitment**   | Use early prototype | High     |
| **Social commitment** | Public endorsement  | High     |

### Problem-Solution Fit

```
You have problem-solution fit when:
┌─────────────────────────────────────────┐
│ ✓ 10+ interviews with consistent pain   │
│ ✓ People are actively seeking solutions │
│ ✓ Current solutions are inadequate      │
│ ✓ Your solution resonates emotionally   │
│ ✓ People offer to pay or pre-order      │
└─────────────────────────────────────────┘
```

---

## Phase 3: MVP Development

### What is MVP?

```
MVP = Minimum VIABLE Product

Minimum: Smallest possible scope
Viable: Actually solves the core problem

MVP is NOT:
✗ Prototype (doesn't need to work)
✗ Beta (feature-complete)
✗ v1.0 (polished)

MVP IS:
✓ Core value proposition only
✓ Works well enough to learn from
✓ Gets real user feedback fast
```

### MVP Types

| Type               | Description                         | Best For           |
| ------------------ | ----------------------------------- | ------------------ |
| **Concierge**      | Manual service disguised as product | Service businesses |
| **Wizard of Oz**   | Human behind automated facade       | Complex systems    |
| **Landing Page**   | Describe + capture interest         | Demand validation  |
| **Video Demo**     | Show concept in action              | Complex products   |
| **Piecemeal**      | Combine existing tools              | Quick market test  |
| **Single Feature** | One core feature, done well         | Software products  |

### MVP Scoping

```
Feature Prioritization Matrix:
                   HIGH IMPACT
                       │
                       │
    "NICE TO HAVE"     │     "MUST HAVE"
    (Maybe Later)      │     (MVP Core)
                       │
    ───────────────────┼───────────────────
                       │
    "DON'T DO"         │     "LOW-HANGING"
    (Never)            │     (If Time Permits)
                       │
                       │
                   LOW IMPACT
    HIGH EFFORT ───────────────── LOW EFFORT
```

### Development Approach

```
Build in iterations:
┌─────────────────────────────────────────┐
│ Week 1-2: Core flow (ugly but works)    │
│ Week 3-4: User feedback, fixes          │
│ Week 5-6: Polish critical path          │
│ Week 7-8: Prepare for launch            │
└─────────────────────────────────────────┘

Principles:
- Ship ugly, learn fast
- Manual before automated
- Fake it till you make it (but don't lie)
- Measure what matters
```

---

## Phase 4: Launch Preparation

### Pre-Launch Checklist

```
PRODUCT:
□ Core functionality works reliably
□ Critical bugs fixed
□ Basic analytics in place
□ Error handling and recovery
□ Onboarding flow tested

MARKETING:
□ Landing page live
□ Value proposition clear
□ Social proof (if available)
□ Email capture working
□ Launch announcement ready

OPERATIONS:
□ Customer support system
□ Payment processing tested
□ Legal basics (ToS, Privacy)
□ Monitoring/alerting set up
□ Rollback plan ready

COMMUNITY:
□ Early access list built
□ Social media accounts ready
□ Launch partners confirmed
□ Press/influencer outreach done
□ Community channels set up
```

### Launch Strategy Options

| Strategy            | Description                | Best For          |
| ------------------- | -------------------------- | ----------------- |
| **Big Bang**        | Public launch with PR push | Strong network    |
| **Soft Launch**     | Quiet release, iterate     | Uncertain product |
| **Waitlist**        | Build anticipation         | High demand       |
| **Beta Program**    | Limited early access       | Complex products  |
| **Platform Launch** | Product Hunt, etc.         | Consumer products |

### Platform Launches

```
PRODUCT HUNT:
- Launch Tuesday-Thursday
- Ship 12:01 AM PST
- Prepare assets in advance
- Engage all day with comments
- Activate your network

HACKER NEWS:
- Show HN format
- Technical angle works best
- Timing matters less
- Be prepared for criticism
- Engage authentically

REDDIT:
- Find relevant subreddits
- Follow community rules
- Don't be promotional
- Add genuine value
- Use for feedback, not sales
```

---

## Phase 5: Launch & Growth

### Launch Day Checklist

```
MORNING:
□ Verify all systems operational
□ Team on standby for issues
□ Launch announcement posted
□ Monitor analytics dashboard

THROUGHOUT DAY:
□ Respond to all comments/questions
□ Fix critical issues immediately
□ Thank early users personally
□ Capture feedback systematically

EVENING:
□ Compile day's metrics
□ Document learnings
□ Plan next day's activities
□ Celebrate (briefly!)
```

### Key Metrics (Early Stage)

| Metric             | What It Measures        | Target          |
| ------------------ | ----------------------- | --------------- |
| **Activation**     | Complete key action     | 40%+ of signups |
| **Retention**      | Return after day 1/7/30 | Varies by type  |
| **NPS**            | Would recommend         | 50+             |
| **Time to Value**  | First "aha" moment      | < 5 minutes     |
| **Support Volume** | Issues per user         | Decreasing      |

### Growth Loops

```
USER-GENERATED:
User creates → Content ranks → New users find
(SEO, community content)

VIRAL:
User invites → Friend joins → Friend invites
(Referrals, sharing)

PAID:
Spend on ads → New users → Revenue → More ads
(Performance marketing)

SALES:
Outreach → Demo → Close → Reference
(B2B enterprise)
```

---

## Business Model Canvas

```
┌───────────────┬───────────────┬───────────────┐
│ Key Partners  │ Key Activities│ Value Props   │
│               │               │               │
│ Who helps us? │ What we do?   │ Why choose us?│
├───────────────┼───────────────┼───────────────┤
│ Key Resources │               │ Customer      │
│               │               │ Relationships │
│ What we need? │               │               │
│               │               │ How we engage?│
├───────────────┼───────────────┼───────────────┤
│ Cost Structure                │ Revenue Streams│
│                               │                │
│ What we spend?                │ How we earn?   │
└───────────────────────────────┴────────────────┘
         │                              │
         ▼                              ▼
┌───────────────┐              ┌───────────────┐
│ Channels      │              │ Customer      │
│               │              │ Segments      │
│ How we reach? │              │ Who we serve? │
└───────────────┘              └───────────────┘
```

---

## Common Mistakes

### Avoid These

```
VALIDATION MISTAKES:
✗ Building before talking to customers
✗ Asking leading questions
✗ Only talking to friends/family
✗ Ignoring negative feedback
✗ "If we build it, they will come"

PRODUCT MISTAKES:
✗ Too many features in MVP
✗ Perfectionism before launch
✗ Solving your problem, not theirs
✗ Ignoring user behavior data
✗ Building in stealth too long

BUSINESS MISTAKES:
✗ No clear business model
✗ Underpricing drastically
✗ Ignoring unit economics
✗ Scaling before product-market fit
✗ Running out of runway
```

### Warning Signs

| Signal                | What It Means                 |
| --------------------- | ----------------------------- |
| No organic growth     | Value proposition unclear     |
| High churn            | Product doesn't deliver value |
| Support overload      | Product/onboarding issues     |
| Feature requests only | Missing core value            |
| Price complaints      | Wrong positioning or audience |

---

## Funding Considerations

### Bootstrapping vs. Raising

```
BOOTSTRAP when:
✓ Can reach profitability quickly
✓ Want full control
✓ Slow growth is acceptable
✓ Capital requirements are low

RAISE when:
✓ Need to move fast (competitive market)
✓ High upfront capital required
✓ Network/credibility from investors helps
✓ Winner-take-all market
```

### Funding Stages

| Stage         | Amount     | Purpose                 |
| ------------- | ---------- | ----------------------- |
| **Pre-seed**  | $50K-$500K | Validate and build MVP  |
| **Seed**      | $500K-$2M  | Find product-market fit |
| **Series A**  | $2M-$15M   | Scale proven model      |
| **Series B+** | $15M+      | Accelerate growth       |

---

## Legal Basics

### Day 1 Essentials

```
MUST HAVE:
□ Business entity formed (LLC or C-Corp)
□ Co-founder agreement (if applicable)
□ Terms of Service
□ Privacy Policy
□ Clear IP ownership

SOON AFTER:
□ Trademark search/filing
□ Employment agreements
□ Contractor agreements
□ Data protection compliance
```

### Entity Types (US)

| Type                  | Best For             | Notes           |
| --------------------- | -------------------- | --------------- |
| **LLC**               | Bootstrapped, simple | Tax flexibility |
| **C-Corp (Delaware)** | Raising VC           | Required for VC |
| **S-Corp**            | Profitable, small    | Tax advantages  |

---

## Best Practices

### DO:

- Talk to users constantly (even after launch)
- Ship fast, learn faster
- Focus on one metric at a time
- Build relationships with early users
- Document your learnings
- Take care of yourself
- Know your runway

### DON'T:

- Build in secret for too long
- Assume you know what users want
- Scale before product-market fit
- Ignore unit economics
- Compete on features alone
- Give up too early (or too late)
- Neglect your health

---

## Launch Readiness Checklist

### Product

- [ ] Core value proposition works
- [ ] Onboarding tested with real users
- [ ] Critical paths error-free
- [ ] Analytics tracking key events
- [ ] Support/feedback mechanism ready

### Go-to-Market

- [ ] Target customer clearly defined
- [ ] Positioning statement finalized
- [ ] Pricing determined and tested
- [ ] Launch channels identified
- [ ] Early users lined up

### Operations

- [ ] Team roles clear
- [ ] Communication channels set up
- [ ] Monitoring and alerting live
- [ ] Legal basics in place
- [ ] Financial tracking ready
