# ESG Reporting Reference

## Reporting Frameworks

| Framework     | Focus                        | Use                |
| ------------- | ---------------------------- | ------------------ |
| **GRI**       | Comprehensive sustainability | General reporting  |
| **SASB**      | Industry-specific, financial | Investor focus     |
| **TCFD**      | Climate risk                 | Climate disclosure |
| **CDP**       | Environmental data           | Benchmarking       |
| **UN SDGs**   | Global goals                 | Impact mapping     |
| **CSRD/ESRS** | EU standards                 | EU operations      |

## GRI Standards

```
GRI STRUCTURE:

UNIVERSAL STANDARDS:
- GRI 1: Foundation
- GRI 2: General Disclosures
- GRI 3: Material Topics

TOPIC STANDARDS:
- GRI 200: Economic
- GRI 300: Environmental
- GRI 400: Social

KEY DISCLOSURES:
- Organizational profile
- Strategy
- Ethics and integrity
- Governance
- Stakeholder engagement
- Reporting practice
- Management approach
- Topic-specific metrics
```

## TCFD Framework

```
TCFD RECOMMENDATIONS:

GOVERNANCE:
- Board oversight of climate
- Management's role

STRATEGY:
- Climate risks and opportunities
- Impact on business/strategy
- Resilience of strategy

RISK MANAGEMENT:
- Risk identification process
- Risk management process
- Integration with overall risk

METRICS & TARGETS:
- Climate-related metrics
- Scope 1, 2, 3 emissions
- Targets and progress
```

## Climate Scenario Analysis

```
SCENARIO PLANNING:

SCENARIOS (IPCC-aligned):
- 1.5°C (Paris-aligned)
- 2°C (Well-below)
- 3°C (Current trajectory)
- 4°C+ (High emissions)

RISK CATEGORIES:

PHYSICAL RISKS:
Acute: Extreme weather, floods, fires
Chronic: Temperature rise, sea level, water stress

TRANSITION RISKS:
Policy: Carbon pricing, regulations
Technology: Disruption, obsolescence
Market: Demand shifts, stranded assets
Reputation: Stakeholder concerns

TIME HORIZONS:
Short: 0-3 years
Medium: 3-10 years
Long: 10-30+ years
```

## ESG Data Management

```
DATA MANAGEMENT PROCESS:

COLLECTION:
- Identify data sources
- Establish ownership
- Define methodologies
- Set collection schedules

VALIDATION:
- Data quality checks
- Completeness review
- Consistency checks
- Third-party verification

REPORTING:
- Consolidation
- Analysis
- Visualization
- Assurance

SYSTEMS:
- ESG data platform
- Automated collection
- Audit trails
- Version control
```

## ESG Ratings

```
MAJOR ESG RATINGS:

MSCI ESG:
- AAA to CCC scale
- Industry-relative
- Focus on material risks

SUSTAINALYTICS:
- Risk rating (0-100)
- Absolute risk level
- Controversy overlay

CDP:
- A to D- scale
- Climate, water, forests
- Action-focused

ISS ESG:
- D- to A+ scale
- Performance-based
- Governance emphasis

IMPROVEMENT STRATEGIES:
- Gap analysis vs. leaders
- Improve disclosure
- Address controversies
- Engage with analysts
```
