# ESG & Sustainability Strategy Templates

## Template 1: ESG Materiality Assessment

### Step 1: Stakeholder Identification

**Internal Stakeholders**

- [ ] Board of Directors
- [ ] Executive Leadership
- [ ] Employees (all levels)
- [ ] Investors/Shareholders
- [ ] Internal ESG/Sustainability Team

**External Stakeholders**

- [ ] Customers/Clients
- [ ] Suppliers/Vendors
- [ ] Community Organizations
- [ ] NGOs/Environmental Groups
- [ ] Industry Associations
- [ ] Regulators/Government
- [ ] Media/Public
- [ ] ESG Rating Agencies

### Step 2: Topic Universe (Based on GRI, SASB, ISSB)

**Environmental Topics**

- [ ] GHG Emissions (Scopes 1, 2, 3)
- [ ] Energy Management & Renewable Energy
- [ ] Water & Wastewater Management
- [ ] Waste & Circular Economy
- [ ] Air Quality & Pollution
- [ ] Biodiversity & Ecosystems
- [ ] Climate Adaptation & Resilience
- [ ] Product Lifecycle & Sustainability
- [ ] Sustainable Packaging & Materials

**Social Topics**

- [ ] Occupational Health & Safety
- [ ] Employee Wellbeing & Benefits
- [ ] Diversity, Equity & Inclusion
- [ ] Labor Relations & Freedom of Association
- [ ] Human Rights in Operations
- [ ] Supply Chain Labor Practices
- [ ] Community Engagement & Impact
- [ ] Customer Health & Safety
- [ ] Data Privacy & Security
- [ ] Product Quality & Responsibility
- [ ] Access & Affordability

**Governance Topics**

- [ ] Board Composition & Effectiveness
- [ ] Executive Compensation
- [ ] Business Ethics & Anti-Corruption
- [ ] Risk Management & Compliance
- [ ] Stakeholder Engagement
- [ ] Transparency & Disclosure
- [ ] Political Contributions & Lobbying
- [ ] Cybersecurity & Data Governance
- [ ] Tax Strategy & Transparency

### Step 3: Stakeholder Engagement Process

**Survey Questions** (Rate 1-5: Not Important to Critical)

1. How important is [Topic] to [Company]'s long-term success?
2. How significant is [Company]'s impact on [Topic] (positive or negative)?
3. Should [Company] publicly disclose performance on [Topic]?

**Engagement Methods**

- [ ] Online surveys (quantitative)
- [ ] Focus groups (qualitative)
- [ ] One-on-one interviews with key stakeholders
- [ ] Review of investor requests and ESG questionnaires
- [ ] Analysis of media coverage and public discourse
- [ ] ESG rating agency feedback

### Step 4: Business Impact Assessment

For each topic, rate **Impact on Enterprise Value** (1-5):

- Financial impact (revenues, costs, asset value)
- Regulatory/legal risk exposure
- Reputational impact
- Operational risk
- Strategic relevance

**Analysis Framework**
| Topic | Stakeholder Importance (1-5) | Business Impact (1-5) | Combined Score | Material? |
|-------|----------------------------|---------------------|---------------|-----------|
| GHG Emissions | [X.X] | [X.X] | [X.X] | Yes/No |
| Water Management | [X.X] | [X.X] | [X.X] | Yes/No |
| DEI | [X.X] | [X.X] | [X.X] | Yes/No |
| [Continue for all topics] | | | | |

### Step 5: Materiality Matrix

**X-Axis**: Importance to Stakeholders (Low → High)
**Y-Axis**: Impact on Business (Low → High)

**Quadrant Classification**:

- **High/High (Top Right)**: Material topics—report and prioritize
- **High/Low**: Stakeholder concern—monitor and communicate
- **Low/High**: Business risk—manage internally
- **Low/Low**: Not material—deprioritize

### Step 6: Material Topics Selection

**Criteria for Material Topics**:

- Combined score ≥ 7.0 (out of 10), OR
- Business impact ≥ 4.0, OR
- Stakeholder importance ≥ 4.5 AND business impact ≥ 3.0

**Final Material Topics** (Target: 5-12 topics):

1. [Topic]: [Rationale]
2. [Topic]: [Rationale]
3. [Topic]: [Rationale]
4. [Topic]: [Rationale]
5. [Topic]: [Rationale]
   [Continue...]

### Step 7: Alignment with SASB

**Industry**: [Select from 77 SASB industries]

**SASB Material Topics for [Industry]**:

1. [SASB Topic]: [Aligned with our topic X]
2. [SASB Topic]: [Aligned with our topic Y]
3. [SASB Topic]: [Not in our assessment—consider adding]

**Validation**: Ensure all SASB material topics for your industry are considered.

### Step 8: Annual Review Process

- [ ] Review materiality annually or when significant business changes occur
- [ ] Re-engage stakeholders every 2-3 years (light refresh annually)
- [ ] Update materiality matrix and disclose changes in ESG report
- [ ] Communicate rationale for topic additions/removals

---

## Template 2: GHG Emissions Inventory Workbook

### Company Information

**Company Name**: [Name]
**Reporting Year**: [Year]
**Baseline Year**: [Year]
**Organizational Boundary**: [Operational control / Financial control / Equity share]
**Reporting Standards**: GHG Protocol Corporate Standard

### Scope 1: Direct Emissions

**1.1 Stationary Combustion** (on-site fuel burning)
| Fuel Type | Quantity | Unit | Emission Factor (kgCO2e/unit) | Total Emissions (tCO2e) |
|-----------|----------|------|------------------------------|------------------------|
| Natural Gas | [X] | therms | 0.0053 | [Auto-calculate] |
| Diesel | [X] | gallons | 0.0102 | [Auto-calculate] |
| Propane | [X] | gallons | 0.0056 | [Auto-calculate] |
| **Subtotal** | | | | **[Sum]** |

**1.2 Mobile Combustion** (company-owned vehicles)
| Vehicle Type | Fuel | Quantity | Unit | Emission Factor | Total Emissions (tCO2e) |
|-------------|------|----------|------|----------------|------------------------|
| Passenger Cars | Gasoline | [X] | gallons | 0.0087 | [Auto-calculate] |
| Trucks | Diesel | [X] | gallons | 0.0102 | [Auto-calculate] |
| Fleet Vehicles | Gasoline | [X] | gallons | 0.0087 | [Auto-calculate] |
| **Subtotal** | | | | | **[Sum]** |

**1.3 Fugitive Emissions** (refrigerants, SF6, etc.)
| Source | Refrigerant Type | Quantity Leaked (lbs) | Emission Factor | Total Emissions (tCO2e) |
|--------|-----------------|---------------------|----------------|------------------------|
| HVAC Systems | R-410A | [X] | [X] | [Auto-calculate] |
| Chillers | R-134a | [X] | [X] | [Auto-calculate] |
| **Subtotal** | | | | **[Sum]** |

**1.4 Process Emissions** (industrial processes, if applicable)
| Process | Quantity | Emission Factor | Total Emissions (tCO2e) |
|---------|----------|----------------|------------------------|
| [Process name] | [X] | [X] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**SCOPE 1 TOTAL**: **[Sum of all Scope 1 subtotals] tCO2e**

---

### Scope 2: Indirect Emissions from Purchased Energy

**2.1 Purchased Electricity** (Location-Based Method)
| Facility/Location | Electricity (kWh) | Grid Emission Factor (kgCO2e/kWh) | Total Emissions (tCO2e) |
|------------------|------------------|----------------------------------|------------------------|
| [Facility 1] | [X] | [X] | [Auto-calculate] |
| [Facility 2] | [X] | [X] | [Auto-calculate] |
| **Subtotal** | **[Sum]** | | **[Sum]** |

**2.2 Purchased Electricity** (Market-Based Method)
| Facility/Location | Electricity (kWh) | Supplier Emission Factor | Total Emissions (tCO2e) |
|------------------|------------------|------------------------|------------------------|
| [Facility 1] | [X] | [X] | [Auto-calculate] |
| [Facility 2] | [X] | [X] | [Auto-calculate] |
| Less: Renewable Energy Certificates (RECs) | [(X)] | | [(X)] |
| **Subtotal** | | | **[Sum]** |

**2.3 Purchased Steam/Heat/Cooling**
| Facility | Type | Quantity (MMBtu) | Emission Factor | Total Emissions (tCO2e) |
|----------|------|-----------------|----------------|------------------------|
| [Facility] | Steam | [X] | [X] | [Auto-calculate] |
| [Facility] | Chilled Water | [X] | [X] | [Auto-calculate] |
| **Subtotal** | | | | **[Sum]** |

**SCOPE 2 TOTAL (Location-Based)**: **[Sum] tCO2e**
**SCOPE 2 TOTAL (Market-Based)**: **[Sum] tCO2e**

---

### Scope 3: Value Chain Emissions

**3.1 Purchased Goods & Services**
| Category | Spend ($) | Emission Factor (kgCO2e/$) | Total Emissions (tCO2e) |
|----------|-----------|---------------------------|------------------------|
| Office Supplies | [X] | [X] | [Auto-calculate] |
| IT Equipment | [X] | [X] | [Auto-calculate] |
| Professional Services | [X] | [X] | [Auto-calculate] |
| Raw Materials | [X] | [X] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**3.2 Capital Goods**
| Asset Type | Spend ($) or Quantity | Emission Factor | Total Emissions (tCO2e) |
|------------|---------------------|----------------|------------------------|
| Buildings | [X] | [X] | [Auto-calculate] |
| Machinery | [X] | [X] | [Auto-calculate] |
| Vehicles | [X] | [X] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**3.3 Fuel & Energy-Related Activities** (not in Scope 1/2)
| Activity | Quantity | Emission Factor | Total Emissions (tCO2e) |
|----------|----------|----------------|------------------------|
| Upstream electricity T&D losses | [Scope 2 kWh] | [X%] | [Auto-calculate] |
| Upstream fuel extraction/transport | [Fuel quantity] | [X] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**3.4 Upstream Transportation & Distribution**
| Mode | Distance (miles) or Spend ($) | Emission Factor | Total Emissions (tCO2e) |
|------|----------------------------|----------------|------------------------|
| Truck | [X] | [X] | [Auto-calculate] |
| Rail | [X] | [X] | [Auto-calculate] |
| Air | [X] | [X] | [Auto-calculate] |
| Ocean | [X] | [X] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**3.5 Waste Generated in Operations**
| Waste Type | Quantity (tons) | Disposal Method | Emission Factor | Total Emissions (tCO2e) |
|-----------|----------------|----------------|----------------|------------------------|
| Landfill | [X] | Landfill | [X] | [Auto-calculate] |
| Recycling | [X] | Recycled | [X] | [Auto-calculate] |
| Composting | [X] | Composted | [X] | [Auto-calculate] |
| Incineration | [X] | Incinerated | [X] | [Auto-calculate] |
| **Subtotal** | | | | **[Sum]** |

**3.6 Business Travel**
| Mode | Distance (miles) or Spend ($) | Emission Factor | Total Emissions (tCO2e) |
|------|----------------------------|----------------|------------------------|
| Air (short-haul) | [X] | [X] | [Auto-calculate] |
| Air (long-haul) | [X] | [X] | [Auto-calculate] |
| Rental Car | [X] | [X] | [Auto-calculate] |
| Hotel Stays | [X nights] | [X] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**3.7 Employee Commuting**
| Mode | Employees | Avg Days/Year | Avg Distance (miles) | Emission Factor | Total Emissions (tCO2e) |
|------|-----------|---------------|---------------------|----------------|------------------------|
| Single-Occupancy Car | [X] | [X] | [X] | [X] | [Auto-calculate] |
| Public Transit | [X] | [X] | [X] | [X] | [Auto-calculate] |
| Bike/Walk | [X] | [X] | [X] | 0 | 0 |
| Remote Work (no commute) | [X] | [X] | 0 | 0 | 0 |
| **Subtotal** | | | | | **[Sum]** |

**3.8 Upstream Leased Assets** (if not in Scope 1/2)
| Asset Type | Energy/Fuel Use | Emission Factor | Total Emissions (tCO2e) |
|-----------|----------------|----------------|------------------------|
| [Office space] | [X kWh] | [X] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**3.9 Downstream Transportation & Distribution**
| Mode | Distance or Spend | Emission Factor | Total Emissions (tCO2e) |
|------|------------------|----------------|------------------------|
| [Mode] | [X] | [X] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**3.10 Processing of Sold Products** (B2B only)
_Not applicable for most companies; estimate if material._

**3.11 Use of Sold Products**
| Product Category | Units Sold | Energy per Unit | Emission Factor | Total Emissions (tCO2e) |
|-----------------|-----------|----------------|----------------|------------------------|
| [Product 1] | [X] | [X kWh/year] | [X] | [Auto-calculate] |
| [Product 2] | [X] | [X kWh/year] | [X] | [Auto-calculate] |
| **Subtotal** | | | | **[Sum]** |

**3.12 End-of-Life Treatment of Sold Products**
| Product Category | Units Sold | Avg Weight | Disposal Method Mix | Emission Factor | Total Emissions (tCO2e) |
|-----------------|-----------|-----------|-------------------|----------------|------------------------|
| [Product 1] | [X] | [X lbs] | [% landfill/recycle] | [X] | [Auto-calculate] |
| **Subtotal** | | | | | **[Sum]** |

**3.13 Downstream Leased Assets**
_Not applicable for most companies._

**3.14 Franchises**
| Franchise Category | Number | Energy Use per Franchise | Emission Factor | Total Emissions (tCO2e) |
|------------------|--------|------------------------|----------------|------------------------|
| [Franchise type] | [X] | [X kWh/year] | [X] | [Auto-calculate] |
| **Subtotal** | | | | **[Sum]** |

**3.15 Investments** (equity, debt, project finance)
| Investment Type | Value ($M) | Emission Factor | Total Emissions (tCO2e) |
|----------------|-----------|----------------|------------------------|
| [Investment 1] | [X] | [X tCO2e/$M] | [Auto-calculate] |
| **Subtotal** | | | **[Sum]** |

**SCOPE 3 TOTAL**: **[Sum of all Scope 3 categories] tCO2e**

---

### Summary

| Scope                      | Emissions (tCO2e) | % of Total |
| -------------------------- | ----------------- | ---------- |
| Scope 1                    | [X]               | [X%]       |
| Scope 2 (Location-Based)   | [X]               | [X%]       |
| Scope 2 (Market-Based)     | [X]               | [X%]       |
| Scope 3                    | [X]               | [X%]       |
| **Total (Location-Based)** | **[Sum]**         | **100%**   |
| **Total (Market-Based)**   | **[Sum]**         | **100%**   |

**Intensity Metrics**

- Emissions per $M revenue: [X] tCO2e/$M
- Emissions per employee: [X] tCO2e/employee
- Emissions per sq ft: [X] tCO2e/sq ft (if applicable)

---

### Data Quality Assessment

| Scope                | Data Source                   | Quality Rating    | Improvement Opportunities |
| -------------------- | ----------------------------- | ----------------- | ------------------------- |
| Scope 1              | [Fuel bills, fleet records]   | [High/Medium/Low] | [Notes]                   |
| Scope 2              | [Utility bills]               | [High/Medium/Low] | [Notes]                   |
| Scope 3 - Category X | [Supplier data / spend-based] | [High/Medium/Low] | [Notes]                   |

**Overall Data Quality**: [X%] of emissions based on primary data vs. estimates

---

## Template 3: Science-Based Targets Commitment

### SBTi Target Setting Template

**Company Information**

- Company Name: [Name]
- Industry (SASB): [Industry]
- Baseline Year: [Year]
- Baseline Emissions:
  - Scope 1: [X] tCO2e
  - Scope 2: [X] tCO2e
  - Scope 3: [X] tCO2e (by category)
  - Total: [X] tCO2e

### Near-Term Science-Based Target (5-10 years)

**Target Year**: 2030
**Pathway**: 1.5°C pathway (aligned with Paris Agreement)

**Scope 1 + 2 Target**:
[Company] commits to reduce absolute Scope 1 and 2 GHG emissions **[42%]** by 2030 from a [baseline year] base year.

**Calculation**:

- Baseline (Scope 1+2): [X] tCO2e
- Required reduction: 42% (per SBTi 1.5°C pathway)
- 2030 Target: [X × 0.58] = [Y] tCO2e
- Absolute reduction: [X - Y] = [Z] tCO2e

**Scope 3 Target** (choose one approach):

**Option A: Absolute Reduction**
[Company] commits to reduce absolute Scope 3 GHG emissions **[25%]** by 2030 from a [baseline year] base year.

**Option B: Supplier Engagement**
[Company] commits that **[67%]** of suppliers by emissions covering purchased goods and services will have science-based targets by 2027.

**Option C: Intensity Reduction** (if growth expected)
[Company] commits to reduce Scope 3 GHG emissions intensity (per $ revenue) **[X%]** by 2030 from a [baseline year] base year.

**Recommended**: Option A (absolute) is most rigorous; Option B is practical for Scope 3-heavy companies.

### Long-Term Net Zero Target

**Target Year**: 2050 (or earlier: 2040, 2045)

**Commitment**:
[Company] commits to reach net-zero greenhouse gas emissions across the value chain by **[2050]**.

**Net Zero Criteria (per SBTi Net Zero Standard)**:

1. Reduce Scope 1, 2, and 3 emissions by at least **90%** by 2050 (from baseline year)
2. Neutralize residual emissions (≤10%) through carbon dioxide removal (CDR) only
3. Set interim targets every 5-10 years

**2030 Interim Target**: See near-term target above
**2040 Interim Target**: [X%] absolute reduction (TBD based on pathway)

### Decarbonization Roadmap (High-Level)

**2024-2027: Foundation**

- Energy efficiency improvements: [X%] reduction
- Renewable electricity procurement: 100% by 2025 (RE100)
- Fleet electrification pilot: [X] EVs
- Supplier engagement launched: [X] suppliers assessed

**2028-2030: Acceleration**

- On-site solar installations: [X] MW capacity
- Fleet 50% electrified
- Eliminate fossil fuel heating (electrify or green hydrogen)
- Top suppliers (50% by emissions) have SBTs

**2031-2040: Deep Decarbonization**

- Breakthrough technologies (green hydrogen, SAF for air travel)
- 100% of suppliers (by emissions) have SBTs
- Circular economy at scale (reduce Scope 3 from materials)
- [X%] emissions reduced

**2041-2050: Net Zero**

- 90%+ total reduction achieved
- Residual emissions ≤10% of baseline
- High-quality carbon removal (not offsets) for remaining emissions
- Nature-based solutions, direct air capture, or other CDR

### Validation & Commitment

- [ ] Submit commitment letter to SBTi
- [ ] Develop detailed targets within 24 months
- [ ] Submit targets to SBTi for validation
- [ ] Disclose publicly upon validation
- [ ] Report progress annually

---

## Template 4: TCFD Climate Risk Assessment

### Governance

**Board Oversight**

- Committee responsible: [Sustainability Committee / Risk Committee / Full Board]
- Frequency of climate review: [Quarterly / Semi-annually]
- Climate expertise on board: [Number] directors with relevant experience
- Board training on climate: [Date of last training]

**Management's Role**

- Executive responsible: [Chief Sustainability Officer / CFO / COO]
- Reporting line: [Reports to CEO / COO]
- Cross-functional climate team: [Members and roles]
- Integration into risk management: [Description]

### Strategy

**Climate-Related Risks & Opportunities**

#### Physical Risks

**Acute Risks**
| Hazard | Assets/Operations Exposed | Time Horizon | Potential Financial Impact | Mitigation Strategy |
|--------|-------------------------|-------------|--------------------------|-------------------|
| Hurricanes | [Coastal facilities in FL, TX] | Medium-term (2030-2040) | $[X]M asset damage | [Facility hardening, insurance] |
| Flooding | [Distribution centers in floodplains] | Near-term (2025-2030) | $[X]M business interruption | [Relocation, backup suppliers] |
| Wildfires | [Facilities in CA] | Near-term (2025-2030) | $[X]M asset damage | [Fire suppression systems, insurance] |

**Chronic Risks**
| Hazard | Assets/Operations Exposed | Time Horizon | Potential Financial Impact | Mitigation Strategy |
|--------|-------------------------|-------------|--------------------------|-------------------|
| Temperature rise | [All facilities; supply chain] | Long-term (2040-2050) | $[X]M increased cooling costs | [Energy efficiency, heat-resistant materials] |
| Water stress | [Facilities in water-scarce regions] | Medium-term (2030-2040) | $[X]M water costs, production limits | [Water recycling, relocation] |
| Sea level rise | [Coastal facilities] | Long-term (2040-2050) | $[X]M asset impairment | [Planned relocation, flood barriers] |

#### Transition Risks

**Policy & Legal**
| Risk | Description | Time Horizon | Potential Financial Impact | Mitigation Strategy |
|------|------------|-------------|--------------------------|-------------------|
| Carbon pricing | [Jurisdiction] implements $[X]/ton CO2 tax | Near-term (2025-2030) | $[X]M annual carbon tax | [Decarbonization to reduce exposure] |
| Emissions regulations | Scope 1+2 limits in [jurisdiction] | Near-term (2025-2030) | $[X]M compliance costs | [Energy efficiency, renewable energy] |
| Disclosure mandates | SEC Climate Rule, EU CSRD | Near-term (2024-2027) | $[X]M reporting/assurance costs | [ESG platform investment, assurance] |

**Technology**
| Risk | Description | Time Horizon | Potential Financial Impact | Mitigation Strategy |
|------|------------|-------------|--------------------------|-------------------|
| EV transition | Internal combustion vehicle obsolescence | Medium-term (2030-2040) | $[X]M asset write-downs | [Accelerate EV transition] |
| Low-carbon tech | Competitors adopt breakthrough tech | Medium-term (2030-2040) | $[X]M revenue loss | [R&D investment, partnerships] |

**Market**
| Risk | Description | Time Horizon | Potential Financial Impact | Mitigation Strategy |
|------|------------|-------------|--------------------------|-------------------|
| Customer demand shift | Customers prefer low-carbon products | Near-term (2025-2030) | $[X]M revenue loss | [Product innovation, lifecycle assessments] |
| Supply chain | Suppliers unable to meet sustainability standards | Near-term (2025-2030) | $[X]M higher costs, delays | [Supplier diversification, engagement] |

**Reputation**
| Risk | Description | Time Horizon | Potential Financial Impact | Mitigation Strategy |
|------|------------|-------------|--------------------------|-------------------|
| Greenwashing | Failure to meet climate commitments | Near-term (2024-2027) | $[X]M brand damage, litigation | [Science-based targets, transparent reporting] |
| Stakeholder pressure | NGO campaigns, investor divestment | Near-term (2024-2027) | $[X]M cost of capital increase | [Ambitious targets, stakeholder engagement] |

#### Climate Opportunities

| Opportunity         | Description                                         | Time Horizon            | Potential Financial Benefit | Strategy to Capture                          |
| ------------------- | --------------------------------------------------- | ----------------------- | --------------------------- | -------------------------------------------- |
| Resource efficiency | Energy/water savings from efficiency                | Near-term (2024-2027)   | $[X]M annual savings        | [Energy audits, LED lighting, HVAC upgrades] |
| Low-carbon products | Revenue from sustainable product lines              | Medium-term (2027-2035) | $[X]M new revenue           | [R&D, marketing, customer education]         |
| Green finance       | Lower interest rates on sustainability-linked loans | Near-term (2024-2027)   | $[X]M interest savings      | [SLL issuance, ESG rating improvement]       |
| Renewable energy    | Cost savings from solar/wind vs. grid               | Medium-term (2027-2035) | $[X]M annual savings        | [PPAs, on-site solar]                        |

### Scenario Analysis

**Scenarios Analyzed**

1. **Below 2°C (Aggressive Climate Action)**: Rapid policy action, high carbon prices, fast energy transition
2. **2-3°C (Moderate Action)**: Gradual policy, moderate carbon prices, slower transition
3. **3-4°C (Business-as-Usual)**: Minimal policy, low carbon prices, severe physical impacts

**Scenario Assumptions**

| Variable                  | <2°C (2030)       | 2-3°C (2030)      | 3-4°C (2030)    |
| ------------------------- | ----------------- | ----------------- | --------------- |
| Carbon Price ($/tCO2)     | $150-200          | $50-100           | $10-30          |
| Renewable Energy Cost     | 50% below 2024    | 30% below 2024    | 20% below 2024  |
| EV Market Share           | 60%+              | 35-45%            | 15-25%          |
| Extreme Weather Frequency | Moderate increase | Moderate increase | Severe increase |
| Avg Temperature Rise      | +1.5-2°C          | +2-3°C            | +3-4°C          |

**Financial Impact by Scenario**

| Scenario | Net Financial Impact (2030) | Key Drivers                                | Strategic Implications                          |
| -------- | --------------------------- | ------------------------------------------ | ----------------------------------------------- |
| <2°C     | [$X]M cost                  | High carbon price, compliance costs        | Accelerate decarbonization to reduce exposure   |
| 2-3°C    | [$X]M cost                  | Moderate carbon price, some physical risks | Balanced approach: decarbonization + adaptation |
| 3-4°C    | [$X]M cost                  | Low carbon price, high physical risks      | Invest in climate resilience and insurance      |

**Business Resilience**:
[Company]'s strategy is resilient across all scenarios due to [reasons: diversified portfolio, early decarbonization investments, climate adaptation plans].

### Risk Management

**Climate Risk Identification**

- Annual climate risk assessment integrated into Enterprise Risk Management (ERM)
- Cross-functional team: Sustainability, Risk, Operations, Finance
- Tools: Climate modeling (Third-party platform), TCFD scenario analysis

**Climate Risk Assessment**

- Likelihood assessment (1-5 scale)
- Impact assessment (1-5 scale: financial, operational, reputational)
- Risk prioritization (likelihood × impact matrix)

**Climate Risk Mitigation**

- Top climate risks assigned owners (C-suite or SVP level)
- Mitigation plans with budgets and timelines
- Quarterly progress reviews
- Board reporting on top risks

**Integration into ERM**

- Climate risks reviewed alongside traditional risks (cyber, operational, financial)
- Climate risk included in annual risk register
- Audit Committee oversight

### Metrics & Targets

**GHG Emissions**
| Scope | [Baseline Year] | [Current Year] | 2030 Target | % to Target |
|-------|----------------|---------------|------------|------------|
| Scope 1 | [X] tCO2e | [X] tCO2e | [X] tCO2e | [X%] |
| Scope 2 (Market) | [X] tCO2e | [X] tCO2e | [X] tCO2e | [X%] |
| Scope 3 | [X] tCO2e | [X] tCO2e | [X] tCO2e | [X%] |
| **Total** | **[X] tCO2e** | **[X] tCO2e** | **[X] tCO2e** | **[X%]** |

**Climate-Related Metrics**

- Renewable energy percentage: [X%] (target: [Y%] by 2030)
- Carbon intensity: [X] tCO2e/$M revenue (target: [Y] by 2030)
- Energy intensity: [X] MWh/$M revenue (target: [Y] by 2030)
- Water intensity: [X] m³/$M revenue (target: [Y] by 2030)

**Climate-Related Financial Metrics**

- Low-carbon revenue: $[X]M ([X%] of total revenue)
- Green capex: $[X]M ([X%] of total capex)
- Internal carbon price: $[X]/tCO2e (used for investment decisions)

**Climate Targets**

- Near-term (2030): [SBTi-validated targets]
- Long-term (2050): Net zero across value chain
- Interim milestones: [2025, 2027, 2035, 2040]

**Progress Tracking**

- Annual GHG inventory and disclosure
- Quarterly KPI dashboard for leadership
- Third-party assurance (Scopes 1 & 2)

---

## Template 5: ESG Report Executive Summary

### Letter from CEO

Dear Stakeholders,

[Opening paragraph: Why ESG matters to the company and CEO personally]

This year, we [key achievement 1], [key achievement 2], and [key achievement 3]. These milestones reflect our commitment to [values: sustainability, people, integrity].

**Our Environmental Progress**
We reduced our greenhouse gas emissions by [X%], bringing us [X%] of the way to our 2030 science-based target. We now source [X%] of our electricity from renewable sources, up from [Y%] last year. Our waste diversion rate reached [X%], with [number] facilities achieving zero-waste-to-landfill certification.

**Our Social Impact**
Our workforce is now [X%] women and [X%] racially/ethnically diverse, an increase of [X] percentage points. We invested $[X]M in employee training and development. Our recordable incident rate dropped to [X] per 100 employees, a [X%] improvement. We contributed $[X]M to community programs, impacting [X] people.

**Our Governance Excellence**
Our Board is now [X%] independent and [X%] diverse by gender. We tied [X%] of executive compensation to ESG metrics, including [specific metrics]. We maintained zero incidents of corruption or ethics violations.

**Looking Ahead**
We're accelerating our path to net zero by 2050, with ambitious interim goals for 2030 and 2040. We're investing $[X]M in circular economy initiatives, aiming for [X%] recycled content in our products by 2030. And we're expanding our social impact programs to reach [X] more communities.

Our ESG strategy isn't separate from our business strategy—it is our business strategy. The companies that thrive in the 21st century will be those that create value for all stakeholders: shareholders, employees, customers, communities, and the planet. We're building that company.

Thank you for your partnership on this journey.

Sincerely,
[CEO Name]

---

### ESG Highlights

**Environmental**

- ⬇ [X%] reduction in GHG emissions (Scopes 1+2) since [baseline year]
- ⬆ [X%] renewable electricity (target: 100% by [year])
- 🔄 [X%] waste diverted from landfill
- 💧 [X%] reduction in water consumption
- 🎯 Science-based emissions targets validated by SBTi

**Social**

- 👥 [X%] employee engagement score
- 📊 [X%] women in leadership (target: [Y%] by [year])
- 🏥 [X] recordable incident rate (industry avg: [Y])
- 💰 $[X]M invested in employee training
- 🤝 $[X]M in community contributions

**Governance**

- 🏛 [X%] independent board directors
- 🌐 [X%] diverse board (gender + racial/ethnic)
- 💼 [X%] of exec comp tied to ESG KPIs
- ⚖ Zero ethics violations or corruption incidents
- 📜 [X%] employees completed ethics training

---

### Our Material ESG Topics

Based on stakeholder engagement and business impact analysis, we focus on these material topics:

**Environmental**

1. Climate Change & GHG Emissions
2. Energy Management & Renewable Energy
3. Waste & Circular Economy
4. Water Stewardship
5. Sustainable Packaging

**Social**

1. Employee Health, Safety & Wellbeing
2. Diversity, Equity & Inclusion
3. Supply Chain Labor Practices
4. Community Engagement

**Governance**

1. Business Ethics & Compliance
2. Board Effectiveness & Diversity
3. Data Privacy & Cybersecurity

---

### Performance Dashboard

**Climate Action**
| Metric | [Prior Year] | [Current Year] | 2030 Target | Progress |
|--------|-------------|---------------|------------|----------|
| Scope 1+2 Emissions (tCO2e) | [X] | [X] | [X] | [X%] ↓ |
| Scope 3 Emissions (tCO2e) | [X] | [X] | [X] | [X%] ↓ |
| Renewable Energy (%) | [X%] | [X%] | 100% | [X%] ↑ |
| Carbon Intensity (tCO2e/$M) | [X] | [X] | [X] | [X%] ↓ |

**Resource Efficiency**
| Metric | [Prior Year] | [Current Year] | 2030 Target | Progress |
|--------|-------------|---------------|------------|----------|
| Waste Diversion Rate (%) | [X%] | [X%] | [X%] | [X%] ↑ |
| Water Intensity (m³/$M) | [X] | [X] | [X] | [X%] ↓ |
| Recycled Content (%) | [X%] | [X%] | [X%] | [X%] ↑ |

**People & Culture**
| Metric | [Prior Year] | [Current Year] | 2030 Target | Progress |
|--------|-------------|---------------|------------|----------|
| Women in Workforce (%) | [X%] | [X%] | [X%] | [X%] ↑ |
| Women in Leadership (%) | [X%] | [X%] | [X%] | [X%] ↑ |
| Racial/Ethnic Diversity (%) | [X%] | [X%] | [X%] | [X%] ↑ |
| Employee Engagement | [X] | [X] | [X] | [X] ↑ |
| Recordable Incident Rate | [X] | [X] | [X] | [X%] ↓ |

**Governance & Ethics**
| Metric | [Prior Year] | [Current Year] | Target |
|--------|-------------|---------------|--------|
| Board Independence (%) | [X%] | [X%] | ≥[80%] |
| Board Diversity (%) | [X%] | [X%] | ≥[40%] |
| Ethics Violations | [X] | [X] | 0 |
| Data Breaches | [X] | [X] | 0 |

---

### Stakeholder Engagement

We engage with stakeholders throughout the year to understand priorities and ensure accountability.

| Stakeholder Group | Engagement Methods                                 | Key Topics                                       | Our Response                                              |
| ----------------- | -------------------------------------------------- | ------------------------------------------------ | --------------------------------------------------------- |
| Investors         | Quarterly earnings calls, ESG roadshows, CDP       | Climate risk, diversity, governance              | TCFD disclosure, SBTs, board diversity                    |
| Employees         | Annual survey, town halls, focus groups            | Wellbeing, DEI, career development               | Wellness programs, DEI targets, training investment       |
| Customers         | Surveys, product feedback, sustainability requests | Product sustainability, supply chain ethics      | Lifecycle assessments, supplier audits                    |
| Communities       | Listening sessions, partnerships, volunteerism     | Local hiring, environmental impact, philanthropy | Community investment, local sourcing, emissions reduction |
| Suppliers         | Assessments, audits, capability building           | ESG requirements, support                        | Supplier Code of Conduct, training programs               |
| NGOs              | Partnerships, issue campaigns                      | Climate action, human rights, biodiversity       | SBTs, supplier transparency, deforestation commitments    |

---

### Recognition & Ratings

**ESG Indices & Rankings**

- ✅ Dow Jones Sustainability Index (DJSI) World
- ✅ FTSE4Good Index
- ✅ CDP Climate Change A List
- ✅ Newsweek Most Responsible Companies (Top 100)
- ✅ Fortune Change the World (Honoree)

**ESG Ratings**

- MSCI ESG Rating: [AA / AAA]
- Sustainalytics ESG Risk: [Low / Negligible] Risk
- ISS ESG: [Prime / Top-Rated]
- S&P Global ESG Score: [XX/100] ([Top Quartile])

---

### Alignment with Frameworks

This report aligns with leading ESG reporting frameworks:

- **GRI** (Global Reporting Initiative): Universal Standards + Topic-Specific Standards
- **SASB** (Sustainability Accounting Standards Board): [Industry] Standard
- **TCFD** (Task Force on Climate-related Financial Disclosures): Full disclosure
- **ISSB** (International Sustainability Standards Board): IFRS S1 & S2 alignment
- **UN SDGs** (Sustainable Development Goals): [List aligned SDGs]

---

## Template 6: Supplier Sustainability Assessment

### Supplier Information

- **Supplier Name**: [Name]
- **Contact**: [Name, Email, Phone]
- **Relationship Duration**: [Years]
- **Annual Spend**: $[X]
- **Category**: [Raw materials / Components / Services]
- **Risk Rating**: [Low / Medium / High] (based on geography, industry, spend)

### Assessment Instructions

Complete this assessment to the best of your ability. Your responses help us understand your ESG performance and identify opportunities for collaboration. All information is confidential.

---

### Section 1: Environmental Management

**1.1 Environmental Policy**

1. Does your company have a documented environmental policy?
   - [ ] Yes (attach or provide link)
   - [ ] No
   - [ ] In development

2. Do you measure greenhouse gas (GHG) emissions?
   - [ ] Yes, Scopes 1, 2, and 3
   - [ ] Yes, Scopes 1 and 2 only
   - [ ] No, but planning to
   - [ ] No

3. If yes, what were your total GHG emissions last year?
   - Scope 1: [X] tCO2e
   - Scope 2: [X] tCO2e
   - Scope 3: [X] tCO2e (if available)

4. Do you have emissions reduction targets?
   - [ ] Yes, science-based targets (SBTi)
   - [ ] Yes, other targets: [describe]
   - [ ] No, but planning to set targets
   - [ ] No

**1.2 Resource Management** 5. What percentage of your electricity comes from renewable sources?

- [ ] 0-25%
- [ ] 26-50%
- [ ] 51-75%
- [ ] 76-100%

6. Do you have water reduction or conservation programs?
   - [ ] Yes (describe): [text]
   - [ ] No

7. What is your waste diversion rate (% not going to landfill)?
   - [ ] 0-25%
   - [ ] 26-50%
   - [ ] 51-75%
   - [ ] 76-100%
   - [ ] Don't measure

**1.3 Environmental Compliance** 8. Have you had any environmental violations or fines in the past 3 years?

- [ ] Yes (explain): [text]
- [ ] No

9. Do you have environmental certifications?
   - [ ] ISO 14001 (Environmental Management)
   - [ ] ISO 50001 (Energy Management)
   - [ ] Other: [specify]
   - [ ] None

---

### Section 2: Social & Labor Practices

**2.1 Labor Rights** 10. Do you comply with ILO (International Labour Organization) core conventions? - [ ] Yes, fully - [ ] Partially - [ ] No - [ ] Unsure

11. Do you prohibit forced labor, child labor, and human trafficking?
    - [ ] Yes, with documented policy
    - [ ] Yes, but no formal policy
    - [ ] No

12. Do you allow freedom of association and collective bargaining?
    - [ ] Yes
    - [ ] No
    - [ ] Not applicable (no unionization)

**2.2 Health & Safety** 13. What is your recordable incident rate (per 100 employees)? - [ ] <1.0 - [ ] 1.0-2.0 - [ ] 2.0-3.0 - [ ] >3.0 - [ ] Don't measure

14. Have you had any workplace fatalities in the past 3 years?
    - [ ] Yes (explain): [text]
    - [ ] No

15. Do you have health and safety certifications?
    - [ ] ISO 45001 (Occupational Health & Safety)
    - [ ] Other: [specify]
    - [ ] None

**2.3 Diversity & Inclusion** 16. What percentage of your workforce is female? - [ ] 0-25% - [ ] 26-50% - [ ] 51-75% - [ ] 76-100%

17. Do you have diversity and inclusion targets or programs?
    - [ ] Yes (describe): [text]
    - [ ] No

**2.4 Human Rights** 18. Do you conduct human rights due diligence in your supply chain? - [ ] Yes, annually - [ ] Yes, periodically - [ ] No, but planning to - [ ] No

19. Have you identified any human rights risks in your operations or supply chain?
    - [ ] Yes (describe mitigation): [text]
    - [ ] No
    - [ ] Not assessed

---

### Section 3: Governance & Ethics

**3.1 Business Ethics** 20. Do you have a Code of Conduct or Code of Ethics? - [ ] Yes (attach or provide link) - [ ] No

21. Do you provide anti-corruption and anti-bribery training?
    - [ ] Yes, annually for all employees
    - [ ] Yes, for relevant roles
    - [ ] No

22. Have you had any ethics violations, corruption, or bribery incidents in the past 3 years?
    - [ ] Yes (explain): [text]
    - [ ] No

**3.2 Data Privacy & Cybersecurity** 23. Do you have data privacy and cybersecurity policies? - [ ] Yes - [ ] No - [ ] Not applicable

24. Have you experienced any data breaches in the past 3 years?
    - [ ] Yes (explain): [text]
    - [ ] No

**3.3 Supply Chain Management** 25. Do you have a Supplier Code of Conduct? - [ ] Yes - [ ] No

26. Do you assess your own suppliers for ESG risks?
    - [ ] Yes, regularly
    - [ ] Yes, occasionally
    - [ ] No

---

### Section 4: Certifications & Reporting

**4.1 ESG Certifications** 27. Which of the following certifications do you hold? (Check all that apply) - [ ] ISO 14001 (Environmental) - [ ] ISO 45001 (Health & Safety) - [ ] ISO 50001 (Energy) - [ ] SA 8000 (Social Accountability) - [ ] B Corp - [ ] Fair Trade - [ ] FSC (Forest Stewardship Council) - [ ] Other: [specify] - [ ] None

**4.2 ESG Reporting** 28. Do you publish a sustainability or ESG report? - [ ] Yes, annually (provide link) - [ ] Yes, periodically - [ ] No

29. Do you disclose to any ESG frameworks or rating agencies?
    - [ ] CDP (Carbon Disclosure Project)
    - [ ] GRI (Global Reporting Initiative)
    - [ ] SASB
    - [ ] TCFD
    - [ ] Other: [specify]
    - [ ] None

---

### Section 5: Improvement & Collaboration

**5.1 ESG Goals** 30. What are your top 3 ESG priorities for the next 2 years? 1. [Text] 2. [Text] 3. [Text]

**5.2 Support Needs** 31. How can [Your Company] support your ESG journey? (Check all that apply) - [ ] Training and capability building - [ ] Access to tools and resources - [ ] Financial support for ESG investments - [ ] Long-term contracts to enable planning - [ ] Collaboration on innovation projects - [ ] Other: [specify]

**5.3 Commitment** 32. Are you willing to set science-based emissions reduction targets within the next 2 years? - [ ] Yes - [ ] Considering - [ ] No

---

### Supplier Signature

By submitting this assessment, I certify that the information provided is accurate to the best of my knowledge.

**Name**: [Name]
**Title**: [Title]
**Date**: [Date]
**Signature**: [Signature]

---

### [Your Company] Use Only

**Assessment Score**: [X/100]
**Risk Rating**: [Low / Medium / High]
**Follow-Up Actions**:

- [ ] Request additional documentation
- [ ] Schedule audit
- [ ] Provide capability building support
- [ ] Recognize as sustainability leader
- [ ] Develop corrective action plan
- [ ] Escalate to senior management

**Assessor**: [Name]
**Date**: [Date]

---

These templates provide a comprehensive foundation for implementing Fortune 50-level ESG and sustainability strategies. They can be customized based on industry, company size, and specific stakeholder requirements.
