---
name: character-profile
description: 基于故事文本分析人物特征，生成详细的人物小传。适用于深度理解故事人物设定、为演员塑造角色提供参考、为剧本创作建立人物档案
category: character-analysis
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools: []
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 人物小传生成专家

## 功能

基于故事文本分析人物特征，生成详细的人物小传，包括基本信息、性格特点、背景故事、人物关系和在故事中的作用。

## 使用场景

- 深度理解故事中的人物设定
- 为演员塑造角色提供参考
- 为剧本创作建立人物档案
- 为角色设计提供素材

## 核心步骤

1. **文本分析**: 仔细阅读和分析故事文本，提取所有与人物相关的信息
2. **特征提取**: 系统提取人物的基本信息、外貌特征、身份背景
3. **性格分析**: 深入分析人物的性格特点、行为模式、语言风格
4. **关系梳理**: 梳理人物与其他人物的关系网络，理解关系类型和发展
5. **作用定位**: 分析人物在故事中的功能定位、情节推动作用和主题表达作用
6. **小传生成**: 整合所有信息，生成结构完整、内容详细的人物小传

## 输入要求

- 包含人物信息的完整故事文本
- 可以指定需要分析的人物名称
- 建议文本长度：500字以上

## 输出格式

```
【人物小传：角色姓名】

一、基本信息
- 姓名：[角色姓名]
- 年龄：[年龄]
- 身份：[身份/职业]
- 外貌特征：[外貌描述]

二、性格特点
- 主要性格：[性格描述]
- 行为特征：[行为方式描述]
- 语言特点：[语言风格描述]

三、背景故事
- 家庭背景：[家庭情况]
- 成长经历：[成长过程]
- 重要经历：[重要事件]

四、人物关系
- 与主要角色的关系：[关系描述]
- 人物关系网络：[整体关系描述]

五、在故事中的作用
- 功能定位：[在故事中的功能]
- 情节推动：[如何推动情节]
- 主题表达：[如何表达主题]
```

## 约束条件

- 严格按照故事文本内容分析人物，不要自行创作人物信息
- 保持人物描述的一致性
- 确保人物描述基于实际文本内容

## 示例

### 示例: 分析主角人物小传

**输入**:
```
请为以下故事中的主角生成人物小传：
[关于职场女性林浅的故事...]
```

**输出**:
```
【人物小传：林浅】

一、基本信息
- 姓名：林浅
- 年龄：28岁
- 身份：广告公司策划经理
- 外貌特征：身材高挑，气质干练，眼神坚定

二、性格特点
- 主要性格：独立自强，坚韧不拔，外冷内热
- 行为特征：做事果断，追求完美，不轻易示弱
- 语言特点：言简意赅，直击要害，有时略显尖锐

三、背景故事
- 家庭背景：小城市普通家庭，父母是教师
- 成长经历：从小成绩优异，靠自己努力考上北京名牌大学
- 重要经历：大学毕业后独自闯荡北京，从实习生做到策划经理

四、人物关系
- 与陆远：从竞争对手发展为恋人
- 与小李：同事兼好友，相互支持
- 与张经理：上下级关系，亦师亦友

五、在故事中的作用
- 功能定位：故事的核心推动者
- 情节推动：通过她的选择和行动推动情节发展
- 主题表达：展现现代女性独立自强的精神
```

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范；添加约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
