---
name: drama-analyzer
description: 分析故事文本，提炼主要情节点并分析戏剧功能。适用于分析小说、剧本大纲、故事梗概等文本，识别关键转折点和情感节点
category: story-analysis
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools: []
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
      - type: added
        content: 添加 references/ 结构存放详细示例
  - version: 1.1.0
    date: 2026-01-10
    changes:
      - type: added
        content: 添加多场景示例
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 剧本分析专家

## 功能

分析故事文本，提炼主要情节点并分析每个情节点的戏剧功能。基于资深编剧的专业视角，深入理解故事结构和戏剧张力。

## 使用场景

- 分析小说或故事文本的核心情节结构，梳理故事脉络
- 识别故事中的关键转折点和情感节点，理解故事节奏
- 评估每个情节点的戏剧作用和推动力，为改编提供依据
- 为剧本改编提供情节分析基础，确保改编质量
- 学习优秀作品的戏剧结构和情节设计技巧

## 核心步骤

1. **深度阅读**: 充分阅读和理解故事文本内容，把握整体结构和主题
2. **情节点识别**: 根据情节点定义，识别并总结故事中的主要情节点
3. **戏剧功能分析**: 深入分析每个情节点在故事中的戏剧作用、推动力和情感影响
4. **结构化输出**: 按照指定格式输出分析结果，确保清晰准确

## 输入要求

- 完整的故事文本（小说、剧本大纲、故事梗概等）
- 文本长度建议：500字以上

## 输出格式

```
【情节点】：<单个情节点描述>
【戏剧功能】：<该情节点的戏剧功能分析>

【情节点】：<单个情节点描述>
【戏剧功能】：<该情节点的戏剧功能分析>
...
```

## 要求

- 每个情节点的表述不超过100字
- 至少提炼5个情节点
- 严格按照故事文本原文意思总结，不自行创作改编
- 不使用阿拉伯数字为情节点标号

## 最佳实践

- **文本选择**: 建议使用完整的故事文本，至少500字以上，确保有足够的情节内容
- **分析深度**: 深入理解故事文本，不要停留在表面，要挖掘情节点的深层戏剧功能
- **客观准确**: 严格按照故事文本原文意思总结，避免自行创作或添加不存在的情节
- **格式规范**: 严格按照输出格式，每个情节点单独成段，清晰标注戏剧功能

## 详细文档

参见 `{baseDir}/references/` 目录获取更多文档:
- `examples.md` - 更多场景示例（悬疑、爱情、职场逆袭、古装宫斗、重生复仇等）
- `guide.md` - 完整分析指南，包含情节点定义和戏剧功能说明

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范；添加约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构，添加 references 结构 |
| 1.1.0 | 2026-01-10 | 添加多场景示例 |
| 1.0.0 | 2026-01-10 | 初始版本 |
