# 竖屏短剧剧本创作指南

## 核心理论体系

### 1. 情绪弹簧理论

情绪弹簧理论是竖屏短剧创作的核心理论，它解释了如何通过情节设计激发和释放观众情绪。

#### 压弹簧（情绪积蓄）

**定义**: 通过制造误会、主角被压制、反派嚣张、危机降临等情节，不断积蓄观众的负面情绪。

**常见手法**:
- **身份压制**: 利用阶层、地位、财富差距制造不公平
- **能力质疑**: 质疑主角的能力、判断或决策
- **情感伤害**: 伤害主角的亲人、朋友或爱人
- **尊严践踏**: 公开羞辱、嘲笑或贬低主角
- **困境叠加**: 连续的倒霉事件，让观众同情

**情绪曲线**: 从0逐渐上升至8-9（满分为10）

#### 放弹簧（情绪释放）

**定义**: 通过主角反转、打脸反派、揭露真相、化解危机等情节，将积蓄的情绪在瞬间彻底释放。

**常见手法**:
- **身份揭晓**: 揭露主角的隐藏身份或真实实力
- **实力碾压**: 用绝对优势击败反派
- **智慧反击**: 用智谋让反派自食其果
- **真相大白**: 揭露被隐瞒的真相，平反冤屈
- **终极反转**: 意想不到的反转，震撼观众

**情绪曲线**: 从8-9瞬间达到10，然后回落至3-4

#### 硬性指标

每一集剧本（1-2分钟）必须执行以下规则之一：
- **纯压弹簧集**: 只积蓄情绪，不释放，为下一集铺垫
- **纯放弹簧集**: 只释放情绪，爽感爆发
- **压放结合集**: 前半段压，后半段放（集内闭环）

---

### 2. 创作方法论

#### 2.1 全局观情绪坐标节奏掌控法则

**核心思想**: 将整部剧看作"情绪K线图"，主动控制情绪曲线。

**操作步骤**:
1. **绘制情绪曲线图**: 横轴为集数，纵轴为情绪值（0-10）
2. **标记关键点**: 标出每个弹簧的压放位置
3. **调整节奏**: 确保情绪曲线有起伏，避免平缓或过度密集
4. **设置高潮**: 每5-10集设置一个情绪高潮点

**示例**:
```
集数: 1  2  3  4  5  6  7  8  9  10
情绪: 3→7→3→9→5→8→2→9→4→10
类型: 压放 压 放 压放 压 放 压 放 压 放
```

#### 2.2 钩子-反转-再钩子单集闭环法则

**核心思想**: 每一集都应有独立的情绪弧线，形成闭环。

**三段式结构**:
1. **开篇钩子（0-20秒）**: 制造悬念或冲突
2. **中段反转（20-90秒）**: 推进情节，设置反转
3. **结尾再钩子（最后10秒）**: 设置悬念，吸引看下一集

**钩子类型**:
- **冲突钩子**: 两人对峙，即将开打
- **悬念钩子**: 提出疑问，但不给答案
- **危机钩子**: 主角陷入危险境地
- **身份钩子**: 某人身份即将揭晓

#### 2.3 信息前置，废话后置台词法则

**核心思想**: 用最直白的台词第一时间抛出身份、冲突、目标。

**信息前置示例**:
```
❌ 错误:
男主: 你最近怎么样？
女主: 还行吧。
男主: 听说你结婚了？
女主: 是啊，三年前就结婚了。

✅ 正确:
女主: 我结婚了，三年前嫁给了你最好的朋友！
```

**废话后置**:
- 情绪释放后，可以加入生活化的对白
- 用于调节节奏，展现人物日常
- 但不能影响主线推进

#### 2.4 动作可视化场景构建法则

**核心思想**: 用强视觉冲击力的"动作"代替"形容词"。

**示例对比**:
```
❌ 错误（形容词堆砌）:
男主非常愤怒，他狠狠地瞪着反派，眼神中充满了杀气。

✅ 正确（动作可视化）:
男主一把揪住反派的衣领，将他狠狠撞在墙上。
反派的头重重磕在墙面上，发出一声闷响。
男主的拳头已经举起，指节因为用力而发白。
```

**可视化技巧**:
- **肢体语言**: 握拳、颤抖、眼神变化
- **环境互动**: 摔东西、砸门、掀桌子
- **物理接触**: 推搡、殴打、拥抱、亲吻
- **道具使用**: 用物品表达情绪（如摔手机）

---

## 剧本格式规范

### 标准格式

```
场次编号. 场景地点 时间 内外景

人物动作和状态描写。

人物A：（情绪/动作）台词内容。

人物B：（情绪/动作）台词内容。

[动作/转换描写]
```

### 格式示例

```
1. 豪华别墅客厅 日 内

林浅坐在沙发上，手里紧紧攥着离婚协议书，指节发白。

陆远：（冷笑）怎么，舍不得签？

林浅：（抬头，眼神坚定）陆远，这三年的感情，在你眼里就一文不值吗？

陆远：（走近，居高临下）值不值，你心里没数吗？你自己做了什么，自己清楚。

林浅猛地站起，将离婚协议书甩在陆远脸上。

林浅：好，既然你要离，那我们就离！但我要让你记住，是你先对不起我的！

林浅转身离去，留下陆远一人站在原地，脸上还贴着那份协议书。
```

### 格式要点

1. **场次编号**: 阿拉伯数字，从1开始
2. **场景地点**: 具体地点（如"豪华别墅客厅"、"公司办公室"）
3. **时间**: 日、夜、黄昏、清晨等
4. **内外景**: 内景（内）、外景（外）、内外景结合（内外）
5. **人物动作**: 独立成段，与台词分开
6. **台词格式**: 人物名：（情绪/动作）台词内容
7. **转场**: 用空行分隔不同场次

---

## 创作流程

### 第一阶段：需求理解

1. **理解用户需求**
   - 创作类型：完整剧本、单集剧本、场景创作
   - 故事类型：都市、古装、甜宠、悬疑等
   - 特殊要求：字数限制、风格偏好、情节要素

2. **分析输入材料**
   - 提取核心信息：人物、关系、冲突
   - 识别创作方向：爽点定位、情绪曲线
   - 明确创作边界：什么能写、什么不能写

### 第二阶段：宏观建构

1. **确定核心爽点**
   - 主角的何种能力或身份是爽点来源
   - 反派的何种行为是情绪积蓄点
   - 观众期待的何种反转是情绪释放点

2. **搭建故事框架**
   - 开篇：如何吸引注意力
   - 发展：如何积蓄情绪
   - 高潮：如何释放情绪
   - 结局：如何留下悬念

3. **设计人物关系**
   - 主角：核心人设、能力背景、成长弧线
   - 反派：对立设定、压制手段、失败方式
   - 配角：功能定位、情感支撑、剧情推动

### 第三阶段：剧本创作

1. **按场创作**
   - 每场明确情绪功能（压或放）
   - 确保情节推进，不拖沓
   - 台词精炼，有信息量

2. **细节打磨**
   - 动作描写要具体可感
   - 台词要符合人物性格
   - 节奏要紧凑，不冗余

3. **格式规范**
   - 严格按照标准格式
   - 标注清晰，易于阅读
   - 场次分明，转场自然

### 第四阶段：精准优化

1. **情绪检查**
   - 每场的情绪功能是否明确
   - 压放比例是否合理
   - 情绪曲线是否有起伏

2. **节奏检查**
   - 是否有拖沓情节
   - 钩子是否吸引人
   - 转场是否自然

3. **台词检查**
   - 信息是否前置
   - 是否有废话
   - 是否符合人物性格

---

## 常见问题与解决方案

### 问题1：情节拖沓

**表现**: 一场戏写了很久，但情节没有推进

**解决**:
- 删除与主线无关的对话
- 合并功能相似的场景
- 加快情节推进速度

### 问题2：台词冗余

**表现**: 角色说了很多，但没传达有用信息

**解决**:
- 信息前置，直奔主题
- 删除寒暄和客套话
- 每句台词都应有功能

### 问题3：情绪平淡

**表现**: 观众没有被爽到，也没有被虐到

**解决**:
- 强化反派的嚣张程度
- 提升主角的能力表现
- 增加反转的震撼程度

### 问题4：格式混乱

**表现**: 场次不清、转场不明、格式不统一

**解决**:
- 严格按照标准格式
- 用空行分隔场次
- 标注时间地点和内外景

---

## 优秀作品分析

### 案例分析：战神归来类

**爽点设计**:
- 主角曾是战神，现在装穷
- 反派看不起主角，各种羞辱
- 主角身份揭晓，反派跪地求饶
- 连锁打脸，爽感叠加

**情绪曲线**:
- 前3集：持续压弹簧，积蓄负面情绪
- 第4集：开始放弹簧，身份逐步揭晓
- 第5集：完全释放，所有反派被打脸

**创作技巧**:
- 钩子设置：每集结尾都有悬念
- 反转设计：身份揭晓分多次，层次递进
- 配角功能：通过配角的反应衬托主角

### 案例分析：甜宠爱情类

**爽点设计**:
- 男主对女主的特殊对待
- 女主的误解和男主的解释
- 误会解除后的甜蜜时刻
- 配角的助攻和捣乱

**情绪曲线**:
- 波动式：甜-虐-甜-虐-大甜
- 小高潮：每3-5集一个小高潮
- 大高潮：第10集左右达到大高潮

**创作技巧**:
- 细节铺垫：通过细节展现感情
- 对话趣味：增加甜蜜有趣的对话
- 场景设计：选择浪漫的场景
