---
name: drama-evaluator
description: 依据竖屏短剧评估标准，从核心爽点、故事类型等维度评估打分。适用于评估故事改编为竖屏短剧的潜力、分析市场竞争力
category: evaluation
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools: []
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
      - type: added
        content: 添加 references/ 结构存放详细示例
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 竖屏短剧评估专家

## 功能

依据竖屏短剧的专业评估标准，从核心爽点、故事类型、人物设定、人物关系、情节桥段等维度对故事文本进行深度评估与打分，分析IP孵化为爆款竖屏短剧的可能性。

## 使用场景

- 评估故事改编为竖屏短剧的潜力
- 分析故事的市场竞争力
- 识别故事的优劣势
- 为故事优化提供专业建议

## 评估维度

### 1. 核心爽点
评估故事是否具备足够强烈的核心爽点

- **普世化程度**: 爽点是否根植于社会大众的普遍渴望或压抑
- **清晰具体化**: 爽点是否具象、可视化
- **节奏递进**: 是否有小爽点、中爽点、大爽点的层层递进

### 2. 故事类型
评估故事类型的市场竞争力

- **强设定**: 是否有极具吸引力的超现实设定
- **经典+创新**: 是否用经典模式吸引观众，并融入创新元素
- **极致化**: 是否将观众熟知的套路极致化

### 3. 人物设定
评估人物设定的有效性和吸引力

- **反差感**: 主角形象反差是否极致
- **欲望明确**: 主角欲望是否单一且明确
- **功能化**: 反派是否高度脸谱化，功能明确

### 4. 人物关系
评估人物关系的戏剧张力

- **强冲突**: 人物关系是否极致二元对立
- **强绑定**: 人物关系是否极度紧密
- **权力结构**: 是否有明确的权力阶层划分

### 5. 情节桥段
评估情节桥段的爽感营造

- **切入矛盾**: 是否省略过程，直接切入核心矛盾
- **情绪极致**: 每一桥段是否只服务于一种极致情绪
- **视觉转化**: 是否能转化为夸张的表情、戏剧性的动作
- **悬念设置**: 每一集结尾是否设置强悬念

## 评分标准

- **8.5分及以上**: 优秀，极强的竞争力和开发价值
- **8.0-8.4分**: 有潜力，较强的竞争力，需要一定修改
- **7.5-7.9分**: 一般，竞争力一般，需要较大修改
- **7.4分及以下**: 较差，竞争力不足

## 工作流程

1. **深入阅读**: 充分阅读和理解故事文本，把握整体结构和核心要素
2. **多维度分析**: 从五个评估维度进行专业分析和打分
3. **对标分析**: 对标市场爆款剧集，分析优势和不足
4. **优化建议**: 提供具体可落地的优化建议
5. **综合评估**: 形成总体评价和开发建议

## 输出格式

### 评估报告格式

```
【竖屏短剧改编潜力评估报告】

【核心爽点】：评分：[X.X]
[概括核心爽点]
[分析与评估，阐述理由与依据]
[对标市场爆款剧集的优势与不足]
[至少2条具体的、可落地执行的优化建议]

【故事类型】：评分：[X.X]
[概括故事类型]
[分析与评估，阐述理由与依据]
[对标市场爆款剧集的优势与不足]
[至少2条具体的、可落地执行的优化建议]

【人物设定】：评分：[X.X]
[梳理主要角色人设]
[分析与评估，阐述理由与依据]
[对标市场爆款剧集的优势与不足]
[至少2条具体的、可落地执行的优化建议]

【人物关系】：评分：[X.X]
[梳理主要人物关系]
[分析与评估，阐述理由与依据]
[对标市场爆款剧集的优势与不足]
[至少2条具体的、可落地执行的优化建议]

【情节桥段】：评分：[X.X]
[梳理所有能够体现核心爽点的情节桥段]
[分析与评估，阐述理由与依据]
[对标市场爆款剧集的优势与不足]
[至少2条具体的、可落地执行的优化建议]

【综合评估】：
[综合上述分析，给出是否建议推进该项目的判断]
[简要说明后续开发的核心风险点与机遇点]
```

## 最佳实践

- **文本完整性**: 提供完整的故事文本，确保评估全面准确
- **客观公正**: 基于专业标准进行评估，不受个人喜好影响
- **对标学习**: 积极对标市场爆款，学习成功经验
- **建议可落地**: 提供的优化建议要具体可执行，避免空泛

## 详细文档

参见 `{baseDir}/references/` 目录获取更多文档:
- `examples.md` - 详细评估示例（都市逆袭、古装宫斗、现代情感等各类题材）
- `guide.md` - 详细评估标准和评分细则

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范；添加约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构，添加 references 结构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
