# 竖屏短剧策划指南

## 策划核心理念

### 1. 情绪价值第一性原理

**核心思想**: 竖屏短剧的本质是情绪产品，成功的关键在于精准识别和高效触发目标受众的核心情绪需求。

#### 情绪价值点的识别

**六大核心情绪**:
1. **爽感**: 打脸、逆袭、复仇、报复
2. **甜感**: 宠溺、保护、付出、牺牲
3. **虐感**: 误会、分离、背叛、伤害
4. **悬念**: 疑问、期待、好奇、探究
5. **共鸣**: 现实、代入、理解、认同
6. **温暖**: 治愈、成长、亲情、友情

**情绪价值评估维度**:
- **普适性**: 该情绪是否被大众广泛理解和认同
- **强度**: 该情绪是否能被强烈激发
- **持久性**: 该情绪是否能持续较长一段时间
- **可复制性**: 该情绪模式是否可以被反复使用

#### 情绪触发机制

**三级触发体系**:
1. **直接触发**: 通过直观的情节直接激发情绪（如打脸）
2. **间接触发**: 通过暗示和铺垫激发情绪（如身份暗示）
3. **连锁触发**: 通过多个情节叠加激发情绪（如连续反转）

**触发技巧**:
- **反差触发**: 前后对比，强化情绪（如从被踩到踩人）
- **积累触发**: 小情绪积累成大情绪（如连续受辱后爆发）
- **意外触发**: 出乎意料，强化冲击（如隐藏身份揭晓）

---

### 2. 黄金三秒钩子法则

**核心思想**: 开篇前3秒决定用户是否继续观看，必须迅速抓住注意力。

#### 三秒设计原则

**视觉冲击**:
- 第一帧就是高能画面
- 避免缓慢铺垫或平淡开场
- 用动作、冲突、悬念制造视觉冲击

**听觉刺激**:
- 用激烈的台词或音效
- 抛出直击人心的疑问
- 制造紧张的对话氛围

**信息密度**:
- 3秒内传递核心冲突
- 快速建立人物关系
- 明确当前情节状态

#### 钩子类型库

**冲突类钩子**:
- 两人对峙，即将开打
- 一方指责另一方
- 突发争吵或争执

**悬念类钩子**:
- 某人身份不明
- 某事真相未明
- 某物用途未知

**危机类钩子**:
- 主角陷入危险
- 重要人物被威胁
- 关键物品丢失

**反转类钩子**:
- 预期之外的情况
- 身份的突然揭示
- 关系的突然变化

#### 三秒设计模板

**模板1：冲突开场**
```
[第一秒] 视觉冲击（如一巴掌扇过去）
[第二秒] 激烈台词（"你竟然..."）
[第三秒] 抛出悬念（为何被打？）
```

**模板2：悬念开场**
```
[第一秒] 神秘画面（如神秘人的背影）
[第二秒] 提出疑问（"他是谁？"）
[第三秒] 暗示后果（"他会改变一切"）
```

**模板3：危机开场**
```
[第一秒] 危险发生（如车祸、绑架）
[第二秒] 人物反应（惊恐、挣扎）
[第三秒] 悬念收尾（能否逃脱？）
```

---

### 3. 期待-压抑-爆发三幕式结构

**核心思想**: 完整的故事应经历建立期待、积累压抑、最终爆发三个阶段。

#### 第一幕：建立期待

**功能**:
- 介绍主角和目标
- 建立故事背景
- 铺设冲突种子

**时长**: 约占整部剧的15-20%

**关键要素**:
- **主角登场**: 展示主角的初始状态
- **目标确立**: 明确主角想要什么
- **障碍预示**: 暗示将要面临的困难

#### 第二幕：积累压抑

**功能**:
- 不断施加压力
- 积累负面情绪
- 制造期待爆发

**时长**: 约占整部剧的60-70%

**关键要素**:
- **冲突升级**: 从小冲突到大冲突
- **情绪积累**: 从小压抑到大压抑
- **反转设置**: 在压抑中设置小反转

**压抑技巧**:
- **加法原则**: 不断给主角施加新的压力
- **减法原则**: 不断剥夺主角的支持和资源
- **延迟原则**: 不断延迟情绪释放的时间

#### 第三幕：爆发释放

**功能**:
- 释放所有积蓄的情绪
- 解决主要冲突
- 达到情绪高潮

**时长**: 约占整部剧的15-20%

**关键要素**:
- **全面反击**: 主角对所有反派进行反击
- **真相大白**: 揭露所有被隐瞒的真相
- **终极反转**: 设置最大的反转情节

---

### 4. 人设即容器理论

**核心思想**: 主角人设是承载受众情感投射的容器，必须标签化和极致化。

#### 人设标签化

**标签作用**:
- 快速识别：让观众快速记住角色
- 情感投射：方便观众代入情感
- 传播效应：便于社交媒体传播

**标签类型**:
- **身份标签**: 战神、总裁、医生、律师等
- **能力标签: 无敌、全知、预知、读心等
- **性格标签**: 冷酷、温柔、腹黑、憨厚等
- **境遇标签: 陨落、隐藏、装穷、卧底等

#### 人设极致化

**极致化原则**:
- **能力极致**: 在某方面达到极致
- **性格极致**: 某种性格特征极度突出
- **反差极致**: 表面与反差极度不同

**极致化示例**:
- **战神极致**: 从不败到被打败再到回归无敌
- **宠溺极致**: 宠到极致，无条件付出
- **腹黑极致**: 表面温柔，实则手段狠辣

#### 人设容器设计

**容器功能**:
1. **承载愿望**: 承载观众未实现的愿望
2. **承载情绪**: 承载观众压抑的情绪
3. **承载幻想**: 承载观众美好的幻想

**设计要点**:
- 容器必须足够"大"（能容纳各种情绪）
- 容器必须足够"深"（能承载深层情感）
- 容器必须足够"稳"（人设前后一致）

---

### 5. 商业化卡点逻辑

**核心思想**: 在情节高潮处设置付费卡点，实现商业价值最大化。

#### 卡点设置原则

**卡点位置**:
- **情绪高潮前**: 在即将释放时卡点
- **悬念揭晓前**: 在真相即将揭露时卡点
- **反转发生前**: 在反转即将发生时卡点

**卡点强度**:
- **弱卡点**: 只是情节中断，可继续观看
- **中卡点**: 情节中断但可猜测后续
- **强卡点**: 情节中断且无法预测后续

#### 卡点设计技巧

**自然过渡**:
- 不要让卡点显得突兀
- 在情节自然的转折点设置
- 让付费成为观众主动选择

**价值呈现**:
- 卡点前必须有高能情节
- 让观众觉得付费值得
- 付费后提供超预期体验

**差异化设计**:
- 不同剧集设置不同卡点
- 同一剧集不同集卡点不同
- 避免观众产生疲劳感

---

## 策划方案制定流程

### 第一步：需求分析

1. **明确策划目标**
   - 是前期策划还是中期调整
   - 是整体方案还是单项方案
   - 目标受众和预期效果

2. **分析现有素材**
   - 故事创意或大纲
   - 目标受众定位
   - 商业化目标

### 第二步：情绪价值分析

1. **识别核心情绪价值点**
   - 主打什么情绪（爽/甜/虐等）
   - 情绪强度如何评估
   - 情绪持续性如何保证

2. **设计情绪触发机制**
   - 直接触发点有哪些
   - 间接触发点有哪些
   - 连锁触发如何设计

3. **绘制情绪曲线图**
   - 横轴：时间/集数
   - 纵轴：情绪强度
   - 标记关键触发点

### 第三步：黄金三秒钩子设计

1. **确定钩子类型**
   - 冲突型、悬念型、危机型或反转型
   - 开场方式选择
   - 视听效果设计

2. **设计三秒内容**
   - 第一秒：视觉冲击
   - 第二秒：台词冲击
   - 第三秒：悬念抛出

3. **优化钩子效果**
   - 测试钩子吸引力
   - 调整钩子强度
   - 确保钩子与主线相关

### 第四步：三幕式结构规划

1. **第一幕：建立期待**
   - 介绍主角和目标
   - 铺设冲突种子
   - 预示困难障碍

2. **第二幕：积累压抑**
   - 设计冲突升级路径
   - 规划情绪积累曲线
   - 设置小反转调节节奏

3. **第三幕：爆发释放**
   - 设计全面反击情节
   - 规划真相揭露方式
   - 设置终极反转

### 第五步：人设容器设计

1. **主角人设设计**
   - 核心标签选择
   - 极致化程度设定
   - 容器功能明确

2. **配角人设设计**
   - 功能定位（助攻/阻碍/对照）
   - 与主角关系设定
   - 自身情绪价值点

3. **反派人设设计**
   - 对立属性设定
   - 压制手段规划
   - 失败方式设计

### 第六步：商业化卡点设置

1. **确定卡点位置**
   - 情节高潮前
   - 悬念揭晓前
   - 反转发生前

2. **设计卡点强度**
   - 根据情节重要性确定
   - 考虑用户接受度
   - 平衡体验和收益

3. **优化卡点体验**
   - 确保自然过渡
   - 提供价值感知
   - 差异化设计

---

## 策划方案评估标准

### 情绪价值评估

- **核心情绪是否明确**: 是否有清晰的主打情绪
- **情绪强度是否足够**: 能否强烈激发目标情绪
- **情绪曲线是否合理**: 是否有起伏和高潮

### 钩子设计评估

- **三秒是否抓住注意力**: 开场是否有足够冲击力
- **钩子类型是否恰当: 钩子类型是否适合该剧类型
- **悬念设置是否有效**: 是否让人想继续看下去

### 结构规划评估

- **三幕结构是否完整**: 期待-压抑-爆发是否完整
- **节奏是否合理**: 是否有张有弛，不拖沓
- **高潮是否有力**: 情绪释放是否足够强烈

### 人设设计评估

- **标签是否清晰**: 是否容易被记住
- **极致化是否到位**: 是否达到极致程度
- **容器功能是否明确**: 是否能承载情感投射

### 商业化评估

- **卡点位置是否恰当**: 是否在最佳位置
- **卡点强度是否合理**: 是否能平衡体验和收益
- **付费意愿是否强**: 观众是否愿意为卡点付费

---

## 常见问题与解决方案

### 问题1：情绪价值不明确

**表现**: 观众不知道该期待什么情绪

**解决**:
- 明确主打情绪类型
- 强化核心情绪点
- 减少干扰情绪

### 问题2：钩子无力

**表现**: 开场平淡，无法吸引继续观看

**解决**:
- 增强视觉冲击
- 强化台词冲突
- 优化悬念设置

### 问题3：结构混乱

**表现**: 三幕结构不清晰，情绪曲线混乱

**解决**:
- 明确三幕划分
- 绘制情绪曲线图
- 调整情节节奏

### 问题4：人设不鲜明

**表现**: 角色标签不清晰，难以记住

**解决**:
- 强化核心标签
- 极致化特征
- 明确容器功能

### 问题5：卡点生硬

**表现**: 付费卡点突兀，影响体验

**解决**:
- 优化卡点位置
- 强化卡点前情节
- 自然过渡处理
