---
name: file-reference
description: 处理和分析用户上传的文件引用，提取关键信息并提供应用建议。适用于解析@符号引用、自然语言引用、提取短剧策划相关信息
category: tools
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools:
  - Read
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、支持的引用格式、核心能力、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加使用场景、约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 文件引用解析专家

## 功能

处理和分析用户上传的文件引用，提取关键信息并提供结构化输出与应用建议。

## 使用场景

- 解析用户在对话中引用的本地文件或URL链接。
- 从文件中提取核心信息，支持智能体理解和利用文件内容。
- 为短剧策划提供文件内容的应用建议，辅助创作。
- 自动化处理各类文件引用，提升工作流效率。

## 支持的引用格式

### @符号引用
- `@文件1` - 文档文件引用
- `@图片1` - 图片文件引用
- `@pdf文档` - PDF文档引用

### 自然语言引用
- "第一个文件"、"第二个文件" - 序号引用
- "最新上传的文件" - 时间引用
- "那个图片文件" - 类型引用

## 核心能力

- **文件引用解析**: 准确识别和解析各种文件引用格式（@符号、自然语言）。
- **内容提取**: 从引用的文件中提取关键信息和核心内容。
- **结构化输出**: 将文件内容以结构化方式呈现，便于理解和利用。
- **应用建议**: 针对文件内容提供在短剧策划中的具体应用建议。

## 输入要求

- **文件引用**: 用户提供的文件引用（如 `@剧本初稿.docx` 或 "刚刚上传的图片"）。
- **分析需求**（可选）: 指定需要从文件中提取的特定信息或分析重点。

## 输出格式

```
## 文件引用分析报告

### 引用摘要
- 引用类型: [@符号引用/自然语言引用]
- 文件类型: [文档/图片/PDF/其他]
- 文件名称: [文件名]

### 文件内容概览
[简要描述文件的主要内容和核心信息]

### 关键信息提取
1. [关键信息点1]
2. [关键信息点2]
3. [关键信息点3]

### 短剧策划应用建议
1. **人物设定**: [如何用于人物角色设计]
2. **情节设计**: [如何用于情节结构规划]
3. **商业化**: [如何用于商业化元素设计]
```

## 约束条件

- 确保文件内容分析的准确性和全面性。
- 重点关注与竖屏短剧策划相关的内容，避免无关信息。
- 提供具体、可操作的应用建议，辅助用户创作决策。
- 避免在输出中引入任何幻觉或不实信息。

## 示例

参见 `{baseDir}/references/examples.md` 目录获取更多详细示例:
- `examples.md` - 包含各种文件类型（如文档、图片、PDF）引用解析和应用建议的详细示例。

## 详细文档

参见 `{baseDir}/references/examples.md` 获取关于文件引用解析的详细指导与案例。

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、支持的引用格式、核心能力、输入要求、输出格式的描述，使其更符合命令式语言规范；添加使用场景、约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
