---
name: ip-evaluator
description: 梳理IP网络信息并进行多维度评估打分。适用于评估小说、剧本等IP的改编价值、分析市场潜力和创新属性
category: evaluation
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools: []
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
      - type: added
        content: 添加 references/ 结构存放详细示例
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# IP评估专家

## 功能

梳理IP网络信息，从市场潜力、创新属性、内容亮点等多个维度进行分析和打分，为IP改编价值提供参考意见。

## 使用场景

- 评估IP改编价值
- 网络小说版权购买前的尽职调查
- IP市场前景分析
- 内容投资决策参考

## 评估维度

### 1. 市场潜力
- **受众适合度**: 判断IP是否贴合目标受众
- **讨论热度**: 判断IP能否引起大众共鸣和讨论
- **稀缺性**: 分析IP内容的独特性与稀缺性
- **播放数据**: 分析IP在市场上的表现前景

### 2. 创新属性
- **核心选点**: 判断IP最核心的故事选点是否新鲜独特
- **故事概念**: 判断IP的故事概念是否突出鲜明
- **故事设计**: 判断IP在故事设计上是否特点鲜明

### 3. 内容亮点
- **主题立意**: 分析IP的主题立意是否清晰明确
- **故事情境**: 判断IP的故事情境是否有张力和戏剧性
- **人物设定**: 判断IP的主要人物设定是否新颖有特点
- **人物关系**: 判断IP的主要人物关系是否出彩鲜明
- **情节桥段**: 判断IP的情节桥段是否有戏剧张力和可看性

## 评分标准

- **8.5分及以上**: 优秀，影视改编价值很大，值得推荐
- **8.0-8.4分**: 有潜力，需要一定程度的修改才能达到优秀
- **7.5-7.9分**: 一般，中规中矩，竞争力一般
- **7.4分及以下**: 较差，竞争力不足，不建议推进

## 工作流程

1. 梳理IP相关信息，总结基本内容
2. 根据评估框架对IP的各个维度进行分析
3. 对每个维度进行严谨、细致的打分
4. 形成总体评价与总评分
5. 给出是否推进IP开发的建议

## 输出格式

```
【IP评估报告】

一、基本信息
- 故事梗概：[IP的故事梗概]
- 故事主题：[IP的故事主题]
- 人物关系：[主要人物及人物关系]
- 市场表现：[口碑、评分、粉丝基础等]
- 作者信息：[作者过往作品及口碑]

二、市场潜力分析
- 受众适合度：[分析+评分]
- 讨论热度：[分析+评分]
- 稀缺性：[分析+评分]
- 播放数据：[分析+评分]

三、创新属性分析
- 核心选点：[分析+评分]
- 故事概念：[分析+评分]
- 故事设计：[分析+评分]

四、内容亮点分析
- 主题立意：[分析+评分]
- 故事情境：[分析+评分]
- 人物设定：[分析+评分]
- 人物关系：[分析+评分]
- 情节桥段：[分析+评分]

五、总体评价
- [总体分析与评价]
- 总评分：[X.X分]

六、建议
- [是否建议推进IP开发的具体建议]
```

## 详细文档

参见 `{baseDir}/references/` 目录获取更多文档:
- `guide.md` - IP评估完整指南，包括评估框架、评分标准、信息获取技巧和注意事项
- `examples.md` - 详细评估示例

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范；添加约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构，添加 references 结构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
