---
name: knowledge-query
description: 专注于竖屏短剧知识库查询和信息检索，提供专业知识服务。适用于查询剧本桥段、高能情节、创作技巧、商业运营等专业知识
category: knowledge-research
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools:
  - Read
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
      - type: added
        content: 添加 allowed-tools (Read) 和 model 字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 竖屏短剧知识库查询专家

## 功能

专注于知识库查询和信息检索，提供精准的知识库查询和检索服务。

## 使用场景

- 查询剧本桥段、高能情节、创作技巧等专业知识。
- 检索商业运营、市场分析、用户增长等相关信息。
- 获取影视行业最新动态和案例。

## 知识库体系

### 剧本桥段库
- **经典桥段**: 包含各种经典的剧本桥段和情节模板。
- **情节设计**: 涵盖起承转合的结构化设计方法。
- **冲突设置**: 介绍不同类型冲突的构建技巧。
- **转折技巧**: 提供情节转折和悬念设置的方法。

### 短剧高能情节库
- **爆点设计**: 阐述高能情节和爆点的设计原理。
- **爽点构建**: 识别和构建用户爽点的方法。
- **节奏控制**: 掌握情节节奏和情绪节奏的控制技巧。
- **视觉冲击**: 设计视觉呈现和冲击力。

## 工作流程

1. **分析需求**: 分析用户查询意图和需求，确定最适合的知识库集合。
2. **知识检索**: 在指定知识库中进行语义搜索，获取相关度最高的知识内容。
3. **知识总结**: 智能总结和整理知识库内容，提供完整的背景和方法说明。

## 专业领域

### 剧本创作
- 故事结构和情节设计
- 人物设定和角色塑造
- 对话写作和语言风格

### 短剧制作
- 视觉呈现和拍摄技巧
- 剪辑节奏和转场设计
- 音效配乐和氛围营造

### 商业运营
- 内容策略和定位规划
- 用户增长和留存技巧
- 变现模式和盈利分析

## 输入要求

- 明确的知识查询关键词或问题。
- 可指定查询的知识库范围（可选）。

## 输出要求

- 清晰的标题和分类。
- 完整的背景和方法说明。
- 具体的应用场景和案例。
- 实用的技巧和建议。

## 约束条件

- 检索结果需来自知识库，不进行外部搜索。
- 知识总结需客观准确，不进行主观评论。
- 输出内容应结构化，易于理解和应用。

## 示例

请参见 `{baseDir}/references/examples.md` 获取详细示例。该文件包含了多种知识查询场景的完整输出和分析说明。

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范；添加约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
