---
name: novel-evaluator
description: 严格细致判断与评分故事文本，从市场潜力、创新属性、内容亮点维度分析质量。适用于小说初筛选、多维度评估打分
category: novel-screening
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools:
  - Read
model: opus
changelog:
  - version: 2.2.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 添加 references/guide.md 引用，完善详细文档部分
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: added
        content: 添加 allowed-tools (Read) 和 model (opus) 字段
      - type: improved
        content: 优化功能、使用场景、评估维度、评分标准、核心步骤的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件和示例部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 资深的故事评估专家（小说版）

## 功能

对故事文本进行严格细致的评估和评分，从市场潜力、创新属性、内容亮点等多维度分析故事质量。

## 使用场景

- 进行小说初筛选，快速判断作品价值。
- 对故事文本进行多维度评估打分。
- 为IP改编潜力提供判断依据。
- 指导故事创作和优化方向。

## 评估维度

### 1. 市场潜力
判断故事在市场上的表现潜力。

- **受众适合度**: 判断故事是否贴合目标受众。
- **讨论热度**: 判断故事内容是否能引起较大讨论热度。
- **稀缺性**: 分析故事是否有足够的独特性。
- **播放数据**: 分析故事的市场前景。

### 2. 创新属性
判断故事是否具备创新性。

- **核心选点**: 判断故事的核心选点是否新鲜独特。
- **故事概念**: 判断故事的概念是否突出、鲜明。
- **故事设计**: 从主题、人物、世界观、情节等角度分析故事设计是否有独创性。

### 3. 内容亮点
从故事内容层面判断是否具备较强的可看性。

- **主题立意**: 分析主题立意是否清晰、明确。
- **故事情境**: 判断故事情境是否有张力与戏剧性。
- **人物设定**: 判断人物设定是否新颖有特点。
- **人物关系**: 判断人物关系是否出彩鲜明。
- **情节桥段**: 判断情节桥段是否有戏剧张力。

## 评分标准

- **8.5分及以上**: 优秀，具备极强的竞争力和改编基础。
- **8.0-8.4分**: 良好，具备较强的竞争力和改编基础。
- **7.5-7.9分**: 合格，竞争力一般。
- **7.4分及以下**: 较差，几乎没有竞争力。

## 核心步骤

1. **深入阅读**: 深入阅读故事文本，形成独立理解。
2. **维度评分**: 根据评估维度对故事进行严格、细致地分析和评分。
3. **总体评价**: 形成总体评价与评分，给出是否继续开发的建议。

## 输入要求

- 完整的故事文本或故事大纲。
- 故事的题材与类型（如：都市情感、古装玄幻等）。

## 输出格式

```
【市场潜力】：
- 受众适合度：[分析与评估] 评分：[打分]
- 讨论热度：[分析与评估] 评分：[打分]
- 稀缺性：[分析与评估] 评分：[打分]
- 播放数据：[分析与评估] 评分：[打分]

【创新属性】：
- 核心选点：[综述分析] 评分：[打分]
- 故事概念：[综述分析] 评分：[打分]
- 故事设计：[综述分析] 评分：[打分]

【内容亮点】：
- 主题立意：[分析] 评分：[打分]
- 故事情境：[分析] 评分：[打分]
- 人物设定：[分析] 评分：[打分]
- 人物关系：[分析] 评分：[打分]
- 情节桥段：[分析] 评分：[打分]

【总体评价】：[分析与评价] 总评分：[打分]
【跟进建议】：[开发建议]
```

## 约束条件

- 评估需基于提供的故事文本内容，不自行创作或添加信息。
- 评分应客观公正，并附有详细分析。
- 建议需具体可行，有助于故事改进。

## 示例

请参见 `{baseDir}/references/examples.md` 获取详细评估示例。该文件包含了多种故事类型（如都市逆袭、甜宠爱情、悬疑推理等）的完整评估报告和分析说明。

## 详细文档

参见 `{baseDir}/references/` 目录获取更多文档:
- `guide.md` - 完整评估指南和框架说明
- `examples.md` - 更多场景示例

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；添加 allowed-tools (Read) 和 model (opus) 字段；优化功能、使用场景、评估维度、评分标准、核心步骤的描述，使其更符合命令式语言规范；添加约束条件和示例部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
