---
name: plot-points-analyzer
description: 分析故事情节点，识别关键情节与转折点。适用于深度分析情节结构、评估情节发展有效性
category: story-analysis
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools:
  - Read
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: added
        content: 添加 allowed-tools (Read) 和 model (opus) 字段
      - type: improved
        content: 优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 情节点分析专家

## 功能

分析故事中的情节点，识别关键情节与转折点，描述情节发展过程。

## 使用场景

- 深度分析故事情节结构，揭示内在逻辑。
- 识别故事的关键转折节点，评估其对剧情的影响。
- 评估情节发展的有效性与合理性。
- 为情节优化与剧本改编提供专业建议。

## 核心步骤

1. **识别**: 识别故事中的所有重要情节点。
2. **重要性评估**: 分析情节点的重要性级别（核心/重要/辅助）。
3. **类型分类**: 按情节功能对情节点进行类型分类（开端/发展/转折/高潮/结局）。
4. **过程描述**: 描述情节点发展的完整过程，包括前置条件、发展与结果。
5. **转折分析**: 分析情节转折点的性质、机制与对情绪的影响。

## 输入要求

- **故事文本或情节大纲**: 完整的原始故事文本或详细的情节大纲。
- **特定分析重点**（可选）: 指定需要重点分析的情节点或方面。

## 输出格式

```
【情节点 X】：情节点名称

1. 情节点类型
   - 类型：[开端/发展/转折/高潮/结局]
   - 功能：具体描述该情节点的功能

2. 情节点重要性
   - 重要性级别：[核心/重要/辅助]
   - 影响范围：描述对整体故事的影响

3. 情节发展过程
   - 前置条件：什么条件导致了这个情节点
   - 发展过程：情节是如何发展的
   - 结果导向：产生了什么结果

4. 转折点分析
   - 转折性质：[正面/负面/中性]
   - 转折机制：转折是如何实现的
   - 情绪影响：对观众情绪的影响

5. 情节对故事的影响
   - 对角色发展的影响
   - 对主线情节的推动作用
   - 对主题表达的贡献
```

## 约束条件

- 分析结果需忠实于原始故事文本，不进行主观臆断。
- 确保情节点分类准确，功能描述清晰。
- 建议具备可操作性，能指导情节优化。

## 示例

参见 `{baseDir}/references/examples.md` 目录获取更多详细示例:
- `examples.md` - 包含不同类型故事（如都市爱情、古装玄幻、悬疑推理）的关键情节点分析示例。

## 详细文档

参见 `{baseDir}/references/examples.md` 获取关于情节点分析的详细指导与案例。

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；添加 allowed-tools (Read) 和 model (opus) 字段；优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范；添加约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
