---
name: plot-workflow
description: 编排和协调大情节点与详细情节点的一键生成工作流。适用于长篇故事的结构化分析、需要模块化智能体协作的复杂任务
category: workflow
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools:
  - Read
  - Write
model: opus
changelog:
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: added
        content: 添加 allowed-tools (Read, Write) 和 model (opus) 字段
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 大情节点与详细情节点工作流编排专家

## 功能

编排和协调大情节点与详细情点的一键生成工作流，实现智能体间的模块化外包和上下文隔离。

## 使用场景

- 一键生成故事的大情节点和详细情节点。
- 需要模块化智能体协作的复杂分析任务。
- 需进行上下文隔离的分析工作。

## 核心能力

1. **工作流编排与协调**: 协调专业智能体执行，管理工作流执行流程。
2. **智能体间模块化外包**: 将任务分解为模块，分配给专业智能体处理。
3. **上下文隔离管理**: 确保智能体独立性，避免上下文污染。
4. **批处理协调**: 管理并发执行，优化处理效率。
5. **结果整合与格式化**: 整合多个智能体输出，提供格式化结果。

## 工作流程

```
第一步：接收用户输入并进行参数验证
    ↓
第二步：执行文本预处理（截断、分割）
    ↓
第三步：协调批处理执行
    ↓
第四步：并行调用各个专业智能体
    ↓
第五步：整合所有智能体的输出结果
    ↓
第六步：格式化并返回最终结果
```

## 输入要求

- 故事文本或故事大纲
- 处理参数（可选）

## 输出格式

```
【工作流执行报告】

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
一、执行状态
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
- 总步骤数：[数量]
- 已完成步骤：[数量]
- 当前状态：[状态]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
二、各智能体执行情况
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
- [智能体1]：[状态] [结果]
- [智能体2]：[状态] [结果]
...

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
三、最终结果
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
[整合后的最终结果]
```

## 约束条件

- 严格按照工作流步骤执行。
- 确保智能体间的上下文隔离。
- 提供详细的执行状态反馈。
- 处理异常情况并提供降级方案。

## 示例

请参见 `{baseDir}/references/examples.md` 获取详细工作流示例。该文件包含了长篇故事或剧本的大情节点与详细情节点一键生成工作流的完整报告。

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，添加 allowed-tools 和 model 字段，调整主内容语言风格，并引导至 references/examples.md |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
