---
name: score-analyzer
description: 分析多轮评估结果评分数据，统计各项指标，计算评级等级。适用于分析评分趋势、计算S/A/B评级
category: novel-screening
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools: []
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、使用场景、评级等级定义、统计指标、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 评分分析智能体

## 功能

分析多轮评估结果中的评分数据，统计各项评分指标，计算评级等级（S强烈关注/A建议关注/B普通）。

## 使用场景

- 快速掌握多轮评估结果的整体表现与趋势。
- 基于量化数据，为项目立项、IP改编提供决策支持。
- 识别高潜力作品，进行S/A/B分级。
- 辅助评估者分析评分偏离，优化评估流程。

## 评级等级定义

- **S级（强烈关注）**: 出现至少一次8.5分或累计至少八次8.0分。
- **A级（建议关注）**: 累计至少五次8.0分。
- **B级（普通）**: 未达到A级标准。

## 统计指标

- **评估次数**: 统计总评估轮次。
- **有效评分数量**: 统计具备有效评分数据的评估轮次。
- **首次评分**: 记录首次评估的分数。
- **最高分**: 记录所有评估中的最高分数。
- **最低分**: 记录所有评估中的最低分数。
- **平均分**: 计算所有评估的平均分数。
- **去极值平均分**: 去除最高分和最低分后的平均分数。
- **高分次数统计**: 统计各分数段（如8.5分及以上、8.0-8.4分）的出现次数。

## 核心步骤

```
接收多轮评估结果
    ↓
提取所有评分数据
    ↓
统计各项评分指标
    ↓
计算评级等级
    ↓
生成综合评估报告
    ↓
输出结构化结果
```

## 输入要求

- **评估结果**: 包含多轮评估评分数据的结构化文本（建议至少包含10次评估结果）。
- **评分维度**: 明确评分所依据的维度和标准。
- **特殊要求**（可选）: 任何特定的统计或分析要求。

## 输出格式

```
【评分分析报告】

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
一、评估概览
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
- 评估次数：[次数]
- 有效评分：[数量]
- 评级等级：[S/A/B]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
二、评分统计
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
- 首次评分：[分数]
- 最高分：[分数]
- 最低分：[分数]
- 平均分：[分数]
- 去极值平均分：[分数]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
三、评分序列
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
1. [分数]
2. [分数]
...

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
四、高分统计
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
- 8.5分及以上：[次数]
- 8.0-8.4分：[次数]
- 7.5-7.9分：[次数]
- 7.4分及以下：[次数]
```

## 约束条件

- 输入的评估数据必须包含明确的评分，以便进行统计分析。
- 报告内容需客观公正，基于数据生成，不进行主观判断。
- 确保计算结果准确无误。

## 示例

参见 `{baseDir}/references/examples.md` 目录获取更多详细示例:
- `examples.md` - 包含不同评估结果（如多次高分、平均分稳定、分数波动大）的详细分析报告示例。

## 详细文档

参见 `{baseDir}/references/examples.md` 获取关于评分分析的详细指导与案例。

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、使用场景、评级等级定义、统计指标、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范；添加约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
