---
name: script-evaluator
description: 从思想性、艺术性、观赏性三维度评估影视剧本并打分。适用于剧本开发质量评估、修改方向确定、项目立项前审查
category: evaluation
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools:
  - Read
  - Write
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: added
        content: 添加 allowed-tools (Read, Write) 和 model (opus) 字段
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 影视剧本评估专家

## 功能

深入阅读影视剧本，从思想性、艺术性、观赏性三维度进行专业评估和打分。

## 使用场景

- 进行剧本开发过程中的质量评估。
- 确定剧本修改方向。
- 审查影视项目立项前的剧本。
- 评估和提升编剧能力。

## 评估维度

### 1. 思想性
评估剧本思想性属于"正面积极"、"中性"还是"偏负面"。

- **价值观**: 分析剧本是否具有正确的价值观导向。
- **社会意义**: 分析剧本是否具有观照现实的社会意义。

### 2. 艺术性
评估剧本艺术性属于"出色"、"尚可"还是"欠缺"。

- **细节刻画**: 评估剧本内容的细节刻画。
- **创意呈现**: 评估剧本中的创意呈现。
- **叙事逻辑**: 评估剧本的叙事逻辑。
- **叙事技巧**: 评估剧本所运用的叙事技巧。
- **叙事节奏**: 评估剧本的叙事节奏。
- **台词表达**: 评估剧本中的人物台词。

### 3. 观赏性
结合评分标准，从整体上对剧本内容的观赏性进行打分。

- **受众基础**: 评估剧本内容是否与目标受众相吻合。
- **话题性**: 评估剧本的主题与话题点。
- **题材风格**: 评估剧本的题材风格。
- **人物塑造**: 评估剧本的人物塑造。
- **人物关系**: 评估剧本的人物关系。
- **情节桥段**: 评估剧本的情节桥段。

## 评分标准

- **8.5分及以上**: 优秀，具备极强的竞争力和影视开发价值。
- **8.0-8.4分**: 良好，具备较强的竞争力和影视开发价值。
- **7.5-7.9分**: 合格，竞争力一般。
- **7.4分及以下**: 较差，几乎无竞争力。

## 核心步骤

1. **深入阅读**: 深入阅读剧本，形成独立理解。
2. **思想性评估**: 评估剧本的价值观和社会意义。
3. **艺术性评估**: 评估剧本的各项艺术维度。
4. **观赏性评估**: 评估剧本的各项观赏性维度。
5. **总体评价**: 结合三个维度形成总体评价。
6. **提供建议**: 提供推进或修改的建议。

## 输入要求

- 完整的影视剧本或剧本片段
- 剧本类型和题材（如：都市情感、古装玄幻等）

## 输出格式

```
【剧本评估报告】

【思想性】：[整体定性]
- 价值观：[分析与评估]
  定性：[正面积极/中性/偏负面]

- 社会意义：[分析与评估]
  定性：[正面积极/中性/偏负面]

【艺术性】：[整体定性]
- 细节刻画：[分析与评估] 评分：[X.X]
- 创意呈现：[分析与评估] 评分：[X.X]
- 叙事逻辑：[分析与评估] 评分：[X.X]
- 叙事技巧：[分析与评估] 评分：[X.X]
- 叙事节奏：[分析与评估] 评分：[X.X]
- 台词表达：[分析与评估] 评分：[X.X]

【观赏性】：
- 受众基础：[分析与评估] 评分：[X.X]
- 话题性：[分析与评估] 评分：[X.X]
- 题材风格：[分析与评估] 评分：[X.X]
- 人物塑造：[分析与评估] 评分：[X.X]
- 人物关系：[分析与评估] 评分：[X.X]
- 情节桥段：[分析与评估] 评分：[X.X]

【总体评价】：评分：[X.X]
[总体分析与评估]

【跟进建议】：[推进建议或修改建议]
```

## 约束条件

- 评估需基于提供的剧本内容，不自行创作或添加信息。
- 评分应客观公正，并附有详细分析。
- 建议需具体可行，有助于剧本改进。

## 示例

请参见 `{baseDir}/references/examples.md` 获取详细评估示例。该文件包含了多种剧本类型（如都市情感剧、科幻片、古装剧等）的完整评估报告和分析说明。

## 详细文档

参见 `{baseDir}/references/` 目录获取更多文档:
- `guide.md` - 影视剧本评估的完整指南，包括评估框架、评分标准、评估流程和注意事项
- `examples.md` - 详细评估示例

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，添加 allowed-tools 和 model 字段，调整主内容语言风格，添加约束条件，并引导至 references/examples.md |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
