---
name: story-five-elements
description: 全面分析故事五元素：题材类型、故事梗概、人物小传、人物关系、大情节点。适用于深度分析故事、剧本改编准备、故事开发文档制作
category: story-analysis
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools: []
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
      - type: added
        content: 添加 references/ 结构存放详细示例
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 故事五元素分析专家

## 功能

分析故事的五个核心元素：题材类型与创意提炼、故事梗概、人物小传、人物关系、大情节点。

## 使用场景

- 全面深度分析故事文本
- 为剧本改编提供完整的五元素分析
- 制作故事开发文档
- 评估故事的整体质量和市场潜力

## 五大核心元素

1. **题材类型与创意提炼**: 分析故事题材、提炼创意元素
2. **故事梗概**: 生成完整的故事梗概
3. **人物小传**: 为主要人物生成详细小传
4. **人物关系**: 分析人物之间的关系网络
5. **大情节点**: 梳理并分析主要情节点

## 核心步骤

1. **文本预处理**: 智能截断和分割长文本，确保分析质量和效率
2. **并行分析**: 高效处理文本片段，调用专业分析模块
3. **五元素分析**: 同时进行题材类型、故事梗概、人物小传、人物关系、大情节点五个维度的专业分析
4. **结果整合**: 整合所有分析结果，生成结构化的综合分析报告
5. **思维导图生成**: 可选生成可视化思维导图，直观展示五元素关系

## 输入要求

- 完整的故事文本（支持长文本）
- 文本长度：无限制（系统会自动处理长文本）

## 输出格式

```
【故事五元素分析报告】

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
一、题材类型与创意提炼
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
[题材类型、创意元素、故事特色、风格特点]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
二、故事梗概
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
[完整的故事梗概，300-500字]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
三、人物小传
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
[为每个主要人物生成的小传]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
四、人物关系
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
[人物关系类型、关系特点、关系发展过程]

━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
五、大情节点
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
[按发展阶段排列的主要情节点]
```

## 详细文档

参见 `{baseDir}/references/` 目录获取更多文档:
- `examples.md` - 详细分析示例（都市情感、古装宫斗、悬疑推理等）
- `guide.md` - 完整五元素分析指南和技巧

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、使用场景、核心步骤、输入要求、输出格式的描述，使其更符合命令式语言规范；添加约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构，添加 references 结构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
