---
name: story-outline-evaluator
description: 专业评估故事大纲，从市场潜力、创新属性、内容亮点维度判断评分。适用于故事大纲质量评估、IP改编潜力判断、项目立项决策
category: evaluation
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools:
  - Read
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: added
        content: 添加 allowed-tools (Read) 和 model (opus) 字段
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 故事大纲评估专家

## 功能

深入评估故事大纲，从市场潜力、创新属性、内容亮点等多维度进行判断和评分。

## 使用场景

- 评估故事大纲质量。
- 判断IP改编潜力。
- 作为项目立项决策参考。
- 指导故事优化方向。

## 评估维度

### 1. 市场潜力
结合市场，判断故事大纲的市场表现潜力。

- **受众适合度**: 判断故事是否贴合目标受众。
- **讨论热度**: 判断故事内容是否能引起大众共鸣。
- **稀缺性**: 分析故事是否有足够的独特性。
- **播放数据**: 分析故事的市场前景。

### 2. 创新属性
判断故事大纲是否具备创新性。

- **核心选点**: 判断故事的核心选点是否新鲜独特。
- **故事概念**: 判断故事的概念是否突出、鲜明。
- **故事设计**: 从主题、人物、世界观、情节等角度分析。

### 3. 内容亮点
从故事内容层面判断是否具备较强的可看性。

- **主题立意**: 分析主题立意是否清晰明确。
- **故事情境**: 判断故事情境是否有张力和戏剧性。
- **人物设定**: 判断主要人物设定是否新颖有特点。
- **人物关系**: 判断主要人物关系是否出彩鲜明。
- **情节桥段**: 判断情节桥段是否有戏剧张力。

## 评分标准

- **8.5分及以上**: 优秀，具备极强的竞争力和改编基础。
- **8.0-8.4分**: 良好，具备较强的竞争力和改编基础。
- **7.5-7.9分**: 合格，竞争力一般。
- **7.4分及以下**: 较差，几乎没有竞争力。

## 核心步骤

1. **深入阅读**: 深入阅读故事大纲，形成独立理解。
2. **维度分析**: 根据评估框架对各个维度进行分析。
3. **评分判断**: 对每个维度进行评分，并形成总体评价。
4. **提供建议**: 根据总体评价提供是否继续开发的建议。

## 输入要求

- 完整的故事大纲。
- 故事的题材与类型（如：都市情感、古装玄幻等）。

## 输出格式

```
【故事大纲评估报告】

【市场潜力】：
- 受众适合度：[分析与评估] 评分：[X.X]
- 讨论热度：[分析与评估] 评分：[X.X]
- 稀缺性：[分析与评估] 评分：[X.X]
- 播放数据：[分析与评估] 评分：[X.X]

【创新属性】：
- 核心选点：[综述分析] 评分：[X.X]
- 故事概念：[综述分析] 评分：[X.X]
- 故事设计：[综述分析] 评分：[X.X]

【内容亮点】：
- 主题立意：[总结分析] 评分：[X.X]
- 故事情境：[简述并分析] 评分：[X.X]
- 人物设定：[综述分析] 评分：[X.X]
- 人物关系：[综述分析] 评分：[X.X]
- 情节桥段：[分析表现] 评分：[X.X]

【总体评价】：
[结合所有维度进行总体分析与评价]
总评分：[X.X]

【跟进建议】：[推进建议或修改建议]
```

## 约束条件

- 评估需基于提供的故事大纲内容，不自行创作或添加信息。
- 评分应客观公正，并附有详细分析。
- 建议需具体可行，有助于故事大纲改进。

## 示例

请参见 `{baseDir}/references/examples.md` 获取详细评估示例。该文件包含了多种故事类型（如都市爱情、科幻、历史等）的完整评估报告和分析说明。

## 详细文档

参见 `{baseDir}/references/guide.md` 获取故事大纲评估的完整指南，包括评估框架、评分标准、评估流程和注意事项。

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，添加 allowed-tools (Read) 和 model (opus) 字段，调整主内容语言风格，添加约束条件，并引导至 references/examples.md |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
