---
name: text-splitter
description: 将文本分割成指定大小的块，保持语义完整性。适用于长文本批处理、将文本分割为可处理的片段
category: tools
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools: []
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、核心能力、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加使用场景、约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 文本分割工具

## 功能

将文本分割成指定大小的块，保持语义完整性，便于后续的批处理和分析。

## 使用场景

- 处理超长文本，将其拆分为智能体可处理的片段。
- 进行文本预处理，为后续的内容分析、摘要或评估任务提供标准化输入。
- 优化文本处理流程，确保每个处理单元的大小可控且语义完整。

## 核心能力

- **语义完整性优先**: 在分割时尽量避免截断句子或段落，优先在自然边界处（如句号、换行符）分割，确保每个块的语义完整性。
- **保持原始格式**: 在分割过程中，努力保留文本的原始格式和结构，例如Markdown、HTML标签等。
- **精确控制块大小**: 严格按照指定的大小限制进行分割，确保每个文本块不超过预设的最大长度。
- **多种分割策略**: 支持基于字符数、token数、段落数或特定分隔符等多种分割策略。

## 输入要求

- **文本内容**: 待分割的原始文本。
- **块大小限制**: 每个文本块的最大长度（建议提供字符数或 token 数）。
- **分割策略**（可选）: 指定分割时优先考虑的策略，如按句分割、按段落分割、按特定分隔符分割等。

## 输出格式

```
【文本分割报告】

- 原始文本长度: [整数] 字/Token
- 目标块大小: [整数] 字/Token
- 实际分割块数: [整数] 块

### 分割结果
- 块1 (长度: [整数] 字/Token): "[内容预览...]"
- 块2 (长度: [整数] 字/Token): "[内容预览...]"
- 块3 (长度: [整数] 字/Token): "[内容预览...]"
...
```

## 约束条件

- 分割结果必须严格符合指定的块大小限制。
- 确保在分割时最大限度地保持文本的语义完整性。
- 输出格式必须结构化，清晰展示每个文本块的内容和长度。
- 避免在输出中引入任何额外信息或解释，只提供分割结果。

## 示例

参见 `{baseDir}/references/examples.md` 目录获取更多详细示例:
- `examples.md` - 包含不同长度、不同分割策略和复杂文本结构的分割示例。

## 详细文档

参见 `{baseDir}/references/examples.md` 获取关于文本分割工具的详细指导与案例。

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、核心能力、输入要求、输出格式的描述，使其更符合命令式语言规范；添加使用场景、约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
