# 文本分割工具 - 详细示例

## 示例 1: 按字符数分割

### 输入

```
文本="这是一段需要被分割的长文本内容。这是第二段内容。这是第三段内容。这是第四段内容。", 分割大小=20, 分割单位=字符
```

### 输出

```
【文本分割结果】

原始长度：47
分割单位：字符
分割大小：20
分割后块数：3

分割块1：
这是一段需要被分割的长文本内容。

分割块2：
这是第二段内容。这是第三段内

分割块3：
容。这是第四段内容。
```

## 示例 2: 按段落分割

### 输入

```
文本="第一段内容
第二段内容
第三段内容
第四段内容", 分割大小=2, 分割单位=段落
```

### 输出

```
【文本分割结果】

原始段落数：4
分割单位：段落
分割大小：2
分割后块数：2

分割块1：
第一段内容
第二段内容

分割块2：
第三段内容
第四段内容
```

## 示例 3: 按句子分割

### 输入

```
文本="这是第一句话。这是第二句话。这是第三句话。这是第四句话。这是第五句话。", 分割大小=2, 分割单位=句子
```

### 输出

```
【文本分割结果】

原始句子数：5
分割单位：句子
分割大小：2
分割后块数：3

分割块1：
这是第一句话。
这是第二句话。

分割块2：
这是第三句话。
这是第四句话。

分割块3：
这是第五句话。
```

## 示例 4: 智能分割（保持语义完整）

### 输入

```
文本="故事讲述了一个年轻女孩的成长历程。她经历了许多困难和挫折，但从未放弃。最终，她通过自己的努力实现了梦想。", 分割大小=30, 智能分割=true
```

### 输出

```
【文本分割结果】

原始长度：56
分割模式：智能分割（保持语义完整）
目标大小：30
分割后块数：2

分割块1：
故事讲述了一个年轻女孩的成长历程。她经历了许多困难和挫折，但从未放弃。

分割块2：
最终，她通过自己的努力实现了梦想。
```
