---
name: text-truncator
description: 智能截断文本，保持内容的完整性和语义连贯性。适用于长文本预处理、确保文本不超过指定长度限制
category: tools
version: 2.1.0
last_updated: 2026-01-11
license: MIT
compatibility: Claude Code 1.0+
maintainer: 宫凡
allowed-tools: []
model: opus
changelog:
  - version: 2.1.0
    date: 2026-01-11
    changes:
      - type: improved
        content: 优化 description 字段，使其更精简并符合命令式语言规范
      - type: changed
        content: 模型更改为 opus
      - type: improved
        content: 优化功能、核心能力、输入要求、输出格式的描述，使其更符合命令式语言规范
      - type: added
        content: 添加使用场景、约束条件、示例和详细文档部分
  - version: 2.0.0
    date: 2026-01-11
    changes:
      - type: breaking
        content: 按照 Agent Skills 官方规范重构
      - type: improved
        content: 优化 description，使用命令式语言，精简主内容
      - type: added
        content: 添加 license、compatibility 可选字段
  - version: 1.0.0
    date: 2026-01-10
    changes:
      - type: added
        content: 初始版本
---

# 文本截断工具

## 功能

智能截断文本，在保持内容完整性和语义连贯性的前提下，将文本截断至指定长度。

## 使用场景

- 对超出长度限制的文本进行预处理，使其符合智能体的输入要求。
- 在展示文本预览或生成摘要时，截取关键部分以提高效率和可读性。
- 辅助内容创作，对生成的长文本进行智能裁剪，避免冗余。

## 核心能力

- **语义优先截断**: 优先在自然语义边界（如句号、问号、感叹号）处进行截断，最大限度地保持句子的完整性。
- **段落完整性**: 在语义边界不足时，优先考虑在段落末尾或换行符处截断，避免破坏段落结构。
- **精确长度控制**: 严格遵守用户指定的最大长度限制，确保输出文本不会超限。
- **截断标记插入**（可选）: 可以在截断文本的末尾自动添加自定义截断标记（如"..."），以指示内容有删节。

## 输入要求

- **文本内容**: 待截断的原始文本（字符串）。
- **最大长度限制**: 文本截断后的最大长度（整数，如字符数或 token 数）。
- **截断标记**（可选）: 自定义截断标记，如 "..." 或 "[内容已截断]"。

## 输出格式

```
【文本截断报告】

- 原始文本长度: [整数] 字/Token
- 截断后长度: [整数] 字/Token
- 截断位置: [位置描述，如 "在第X句末尾"] 或 "未截断"

### 截断后的文本
[截断后的文本内容]
```

## 约束条件

- 截断后的文本长度必须严格符合最大长度限制。
- 确保截断后的文本在语义上尽可能连贯和完整。
- 如果文本未达到最大长度，则不进行截断，返回原始文本。
- 输出格式必须结构化，清晰展示截断前后的长度信息和截断后的文本内容。

## 示例

参见 `{baseDir}/references/examples.md` 目录获取更多详细示例:
- `examples.md` - 包含不同长度、不同截断标记和复杂文本结构的截断示例。

## 详细文档

参见 `{baseDir}/references/examples.md` 获取关于文本截断工具的详细指导与案例。

---

## 版本历史

| 版本 | 日期 | 变更 |
|------|------|------|
| 2.1.0 | 2026-01-11 | 优化 description 字段，使其更精简并符合命令式语言规范；模型更改为 opus；优化功能、核心能力、输入要求、输出格式的描述，使其更符合命令式语言规范；添加使用场景、约束条件、示例和详细文档部分。 |
| 2.0.0 | 2026-01-11 | 按官方规范重构 |
| 1.0.0 | 2026-01-10 | 初始版本 |
