---
name: social-media
description: Create social media content for Twitter/X, LinkedIn, Facebook, Instagram including posts, threads, carousels, and engagement strategies. Use when writing social posts, planning content calendars, or creating viral content.
---

# Social Media Marketing Skill

## Writing Style Guidelines

**Be Human, Not AI:**
- Write like a real person, not a marketing bot
- Use natural language and conversational tone
- Avoid buzzwords: "revolutionary", "game-changing", "seamless", "leverage"
- Skip filler words: "basically", "essentially", "simply", "just"

**Emoji Policy:**
- Maximum ONE emoji per post (or none)
- Use only when it genuinely adds clarity or warmth
- Never pile up emojis (no "Check this out! 🚀🔥💥🎉")
- Professional platforms (LinkedIn): prefer no emoji

**What to Avoid:**
```
❌ "🚀🔥 This GAME-CHANGING plugin will REVOLUTIONIZE your workflow!! 💥✨🎉"
✅ "Tired of manually syncing your forms? This plugin does it automatically."
```

## Instructions

When creating social media content:

### 1. Twitter/X Posts

**Single Tweet (280 chars):**
```
Hook line that grabs attention

Key point or benefit

Call-to-action or question

#relevanthashtag
```

**Thread Format:**
```
Thread: [Topic] - Everything you need to know

1/ Hook that promises value

2/ First key point with example

3/ Second key point with data

4/ Third key point with tip

5/ Summary + CTA

Like & RT if helpful! Follow for more.
```

**Engagement Tweets:**
- Ask genuine questions
- Share honest takes (not hot takes for engagement)
- Create polls
- Reply to trends (only if relevant)

### 2. LinkedIn Posts

**Structure:**
```
Hook line (stops the scroll)

Problem or pain point

Story or insight (2-3 short paragraphs)

Key takeaway or lesson

Call-to-action + question for engagement

---
#hashtag1 #hashtag2 #hashtag3
```

**Content Types:**
- Personal stories with lessons
- Industry insights and trends
- How-to and practical tips
- Behind-the-scenes
- Achievements (genuine, not humble-brag)
- Thoughtful opinions (not controversial for engagement)

### 3. Instagram

**Caption Structure:**
```
Hook (first line visible)
.
.
.
Value content or story (after "more")

Call-to-action

.
.
.
#hashtag1 #hashtag2 ... (up to 30)
```

**Carousel Ideas:**
1. Step-by-step tutorials
2. Before/after transformations
3. Tips and tricks lists
4. Product features
5. Customer testimonials

**Reels/Stories:**
- Hook in first 3 seconds
- Quick value delivery
- Trending audio (if appropriate)
- Text overlays for accessibility
- Clear CTA at end

### 4. Facebook

**Post Types:**
- Long-form stories
- Questions for engagement
- Live videos
- Group discussions
- Event promotions

**Best Practices:**
- Native video over YouTube links
- Engage in comments quickly
- Use Facebook-specific features
- Post when audience is active

### 5. Content Calendar Template

| Day | Platform | Content Type | Topic | CTA |
|-----|----------|--------------|-------|-----|
| Mon | Twitter | Thread | How-to | Follow |
| Tue | LinkedIn | Story | Lesson | Comment |
| Wed | Instagram | Carousel | Tips | Save |
| Thu | Twitter | Poll | Opinion | Vote |
| Fri | All | Promo | Product | Link |

### 6. Hashtag Strategy

**Twitter:** 1-2 relevant hashtags (less is more)
**LinkedIn:** 3-5 industry hashtags
**Instagram:** 20-30 mixed hashtags
  - 10 broad (1M+ posts)
  - 10 medium (100K-1M)
  - 10 niche (<100K)

### 7. Engagement Tactics

**Boost Reach:**
- Post consistently
- Engage with others first (genuinely, not for algorithm)
- Reply to every comment
- Use platform features (polls, lives)
- Collaborate with others

**Build Community:**
- Ask genuine questions
- Share user content (with credit)
- Be authentic and consistent
- Celebrate followers
- Respond like a human, not a brand

### 8. Analytics Focus

Track:
- Impressions/reach
- Engagement rate
- Click-through rate
- Follower growth
- Best posting times
- Top performing content types

### 9. Platform-Specific Tips

**Twitter/X:**
- Tweet 3-5x daily
- Best times: 8-10am, 12-1pm
- Use threads for long content
- Quote tweet for commentary

**LinkedIn:**
- Post 1x daily max
- Best times: Tue-Thu, 7-8am
- Comment on others' posts
- Use document posts for carousels

**Instagram:**
- Post 1-2x daily
- Best times: 11am-1pm, 7-9pm
- Stories multiple times daily
- Reels for growth

## Quality Checklist

Before posting, verify:

### Content
- [ ] Clear hook in first line
- [ ] Value provided (not just promotion)
- [ ] One clear CTA
- [ ] Appropriate hashtags
- [ ] Links work (if any)

### Tone
- [ ] Human, conversational tone
- [ ] Maximum one emoji (if any)
- [ ] No buzzwords or filler words
- [ ] Not salesy or pushy
- [ ] Authentic to brand voice

### Visual (if applicable)
- [ ] Real screenshots (not mockups)
- [ ] Alt text for accessibility
- [ ] No sensitive data visible
- [ ] Properly sized for platform
