# Aesthetic Playbook

Use these ready-to-go directions to avoid generic looks. Pick one and commit; swap fonts/colors as needed but keep the intent.

## Brutalist Raw
- Fonts: Display `Bricolage Grotesque` or `Migra`; Body `IBM Plex Sans` or `Atkinson Hyperlegible`.
- Colors: Harsh contrast (charcoal/ivory) with one acidic accent (#ff5c39 or #f2ff49). Keep surfaces flat with thick borders.
- Layout: Grid-breaking blocks, oversized headings, visible rules, obvious gutters. Use all-caps labels and numeric tags.
- Motion: Snappy entrance (0.35s) with slight overshoot; hover states that invert colors or reveal underlines.
- Backgrounds: Checkerboard, dotted patterns, or single bold stripe angled across the hero.

## Editorial / Magazine
- Fonts: Display `Canela`, `Fraunces`, or `Cormorant Garamond`; Body `Newsreader` or `Source Serif 4`; Accents `DM Mono`.
- Colors: Muted palettes (deep ink, warm off-white, burnt orange accents). Let photos bleed to the edge.
- Layout: Tall columns, asymmetrical whitespace, floating pull-quotes, generous line-height. Use hairline rules and small caps.
- Motion: Slow fades (0.6s) and subtle parallax on hero imagery. Stagger text reveals by 80–120ms.
- Backgrounds: Fine grain or paper texture overlay with low opacity.

## Retro-Futuristic Neon
- Fonts: Display `Space Mono` or `Bungee`; Body `Sora` or `DM Sans`.
- Colors: Dark base (#05060e) with neon accents (#61f4de, #ff6ad5, #8af5ff). High glow shadows.
- Layout: Angled cards, pill buttons, floating ribbons, console-style stats. Use thin outlines and scanlines.
- Motion: Glitch keyframes, sweep highlights on hover, marquee strips for metadata.
- Backgrounds: Gradient mesh with cyan/magenta, layered with transparent grid lines or starfield dots.

## Soft Craft / Pastel
- Fonts: Display `Clash Display` or `Epilogue`; Body `Manrope` or `Sen`.
- Colors: Warm pastel base (#f6ede3) with clay/terracotta (#d96b52) and sage (#8ca28f) accents.
- Layout: Rounded blobs, gentle shadows (20–30px blur), stacked cards with stitched borders, hand-drawn icons if available.
- Motion: Ease-in-out float (2–4s) on background shapes; hover lifts with shadow color shifts.
- Backgrounds: Irregular gradient blobs, subtle noise at 8–12% opacity to avoid flatness.

## Industrial / Utilitarian
- Fonts: Display `Compacta` or `Archivo Black`; Body `Barlow` or `Work Sans`; Numerics `JetBrains Mono`.
- Colors: Cold neutrals (#101010, #e6e6e6) with hazard accents (#ffb400 or #2de1c2). Use muted teal for secondary.
- Layout: Rigid grids, labeled panels, visible coordinates and data tags, boxed callouts with corner ticks.
- Motion: Linear 0.25–0.35s transitions; sliding panels; progress bars with stripes.
- Backgrounds: Carbon fiber or diagonal hatch via CSS repeating-linear-gradients; add soft inner glow for depth.

## How to Choose
1. Identify the emotional goal (edgy, luxe, calm, industrial, playful).
2. Pick fonts first, then colors that suit the fonts’ character.
3. Decide on a single signature move (checkerboard stripe, neon glow, magazine pull-quote). Everything else supports it.
