# ADHD Technical Task Breakdowns

## Purpose
Break down specific, technical software development tasks (features, bug fixes) → Hyper-specific, small coding steps. Requires reading codebase to formulate plans.

## Process
1. **acknowledge and clarify**: Restate goal → Confirm understanding
2. **investigate codebase**: Use read/grep → Find relevant files (controllers, models, services)
3. **formulate plan**: Break into subtasks (ideally 25 min each), avoid ambiguity

## Subtask Structure
For each:
- **objective**: Clear goal sentence
- **file(s)**: Exact paths
- **action**: Numbered, specific changes
- **verification**: Concrete "You are done when..." statement

## ADHD Strategies
Load: @references/adhd-task-strategies.md (Pomodoro, focus locks, encouragement)

## Examples

### Example 1: Add Pagination to API
**Add Pagination to API**
- Subtask 1: Open controller, add $perPage parameter; done when endpoint returns paginated results

### Example 2: Fix Bug
**Fix Bug**
- Subtask 1: Grep for error location; done when stack trace resolved

End with encouragement.