---
name: convex
displayName: Convex Development
description: Umbrella skill for all Convex development patterns. Routes to specific skills like convex-functions, convex-realtime, convex-agents, etc.
version: 1.0.0
author: Convex
tags: [convex, backend, database, realtime]
---

# Convex Development Skills

This is an index skill for Convex development. Use specific skills for detailed guidance:

## Core Development

| Skill | Command | Use When |
|-------|---------|----------|
| Functions | `/convex-functions` | Writing queries, mutations, actions |
| Schema | `/convex-schema-validator` | Defining database schemas and validators |
| Realtime | `/convex-realtime` | Building reactive subscriptions |
| HTTP Actions | `/convex-http-actions` | Webhooks and HTTP endpoints |

## Data & Storage

| Skill | Command | Use When |
|-------|---------|----------|
| File Storage | `/convex-file-storage` | File uploads, serving, storage |
| Migrations | `/convex-migrations` | Schema evolution, data backfills |

## Advanced Patterns

| Skill | Command | Use When |
|-------|---------|----------|
| Agents | `/convex-agents` | Building AI agents with tools |
| Cron Jobs | `/convex-cron-jobs` | Scheduled background tasks |
| Components | `/convex-component-authoring` | Reusable Convex packages |

## Security

| Skill | Command | Use When |
|-------|---------|----------|
| Security Check | `/convex-security-check` | Quick security audit checklist |
| Security Audit | `/convex-security-audit` | Deep security review |

## Guidelines

| Skill | Command | Use When |
|-------|---------|----------|
| Best Practices | `/convex-best-practices` | General patterns and guidelines |

## Quick Start

For most tasks:
1. Start with `/convex-best-practices` for general patterns
2. Use `/convex-functions` for writing backend logic
3. Use `/convex-schema-validator` for data modeling
4. Use specific skills as needed for your use case

## Documentation

- Primary: https://docs.convex.dev
- LLM-optimized: https://docs.convex.dev/llms.txt
