---
name: design-sprint
description: Use when asked to "run a design sprint", "5-day sprint", "prototype in a week", "test ideas before building", or "Jake Knapp sprint". Helps teams go from problem to tested prototype in five days. The Design Sprint framework (created by Jake Knapp at Google Ventures) compresses months of work into one focused week.
---

# Design Sprint

## What It Is

A Design Sprint is a five-day process for answering critical business questions through design, prototyping, and testing with customers. Developed by Jake Knapp at Google Ventures (now GV), it has been used by teams at Slack, Uber, Airbnb, LEGO, the New York Times, and hundreds of startups.

The core insight: **Instead of debating ideas for months then building for months, compress everything into one week.** By Friday, you'll have tested a realistic prototype with real customers and know whether you're on the right track.

A Design Sprint changes the defaults of how teams work:
- Instead of endless brainstorming: structured individual sketching
- Instead of design by committee: one Decider with authority
- Instead of building real products: realistic "fake" prototypes
- Instead of launching and hoping: testing with 5 target customers

## When to Use It

Use a Design Sprint when:

- **You're starting something new** and need to validate direction before committing engineering resources
- **Stakes are high** — the project will require significant investment and you need confidence before building
- **You're stuck** — the team has been debating the same ideas for weeks or months without progress
- **There's a big behavioral risk** — the product requires customers to change how they work or think
- **You need alignment** — stakeholders have different visions and you need a forcing function
- **Time pressure exists** — you have a deadline, a launch window, or limited runway

## When Not to Use It

**Don't use a Design Sprint when:**

- You already have strong signal from existing customers (iterate instead)
- The solution is obvious and low-risk (just build it)
- Key stakeholders can't commit to the full week
- You don't have access to target customers for testing
- The team wants to use it as "innovation theater" without intent to act on findings
- The problem is purely technical with no user-facing component

## Patterns

Detailed examples showing how to apply Design Sprints correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your week)

| Pattern | What It Teaches |
|---------|-----------------|
| [wrong-problem-for-sprint](patterns/wrong-problem-for-sprint.md) | Not every problem benefits from a sprint — pick the right challenge |
| [missing-decider](patterns/missing-decider.md) | Without a Decider present, the sprint stalls or gets overturned |
| [prototype-too-polished](patterns/prototype-too-polished.md) | Goldilocks quality — realistic enough to test, rough enough to throw away |
| [testing-wrong-users](patterns/testing-wrong-users.md) | Five target customers beats fifty random people |
| [skipping-the-map](patterns/skipping-the-map.md) | Jumping to solutions without mapping the problem guarantees misalignment |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [group-brainstorming](patterns/group-brainstorming.md) | Work alone together — individual sketching beats group ideation |
| [too-many-ideas](patterns/too-many-ideas.md) | Commit to one prototype, not a choose-your-own-adventure |
| [expert-interviews-skipped](patterns/expert-interviews-skipped.md) | Monday interviews surface constraints you'd otherwise discover Friday |
| [storyboard-too-vague](patterns/storyboard-too-vague.md) | The storyboard is the blueprint — vague boards create confused prototypes |
| [prototype-scope-creep](patterns/prototype-scope-creep.md) | Prototype the critical path, not the whole product |
| [testing-for-validation](patterns/testing-for-validation.md) | You're testing to learn, not to prove you were right |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [ignoring-sprint-questions](patterns/ignoring-sprint-questions.md) | Write sprint questions Monday, answer them Friday |
| [facilitator-participates](patterns/facilitator-participates.md) | Facilitators facilitate — they don't pitch their own ideas |
| [no-debrief](patterns/no-debrief.md) | Friday's patterns need synthesis before Monday's decisions |


## Deep Dives

Read only when you need extra detail.

- `references/design-sprint-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Books:**
- *Sprint* by Jake Knapp with John Zeratsky and Braden Kowitz — the complete guide
- *Make Time* by Jake Knapp and John Zeratsky — tactics for focus and energy that power productive sprints

**Online:**
- [The Sprint Book](https://www.thesprintbook.com/) — free resources, Miro template, video walkthroughs
- [GV Library](https://library.gv.com/) — essays and case studies from Google Ventures
- [Character Labs](https://character.vc/labs) — Jake and John's accelerator program using sprint sequences

**Origins:**
The Design Sprint was developed by Jake Knapp at Google, refined through hundreds of sprints at Google Ventures, and documented in the 2016 book *Sprint*. It draws on design thinking, IDEO methods, and psychological research on decision-making and creativity.
