---
title: Goldilocks Quality — Not Too Polished, Not Too Rough
impact: CRITICAL
tags: prototype, thursday, quality
---

## Goldilocks Quality — Not Too Polished, Not Too Rough

The prototype needs to be realistic enough that customers can engage naturally, but rough enough that the team can throw it away. Both extremes kill sprints.

**Incorrect (too polished):**

> **Thursday:** Designer insists on pixel-perfect screens. Engineer builds a working database. Writer polishes every word.
>
> **End of Thursday:** Prototype is 60% done. Team stays until midnight.
>
> **Friday:** Beautiful prototype, but it only covers half the storyboard. Customers can't complete the flow.
>
> **Worse:** Team is so proud of the work that they can't hear critical feedback. "They just didn't understand it."
>
> *Result:* Couldn't test the full hypothesis. Sunk cost fallacy prevents pivoting.

**Incorrect (too rough):**

> **Thursday:** Team throws together wireframes with placeholder text. "Customers will get the idea."
>
> **Friday Interview 1:**
> Customer: "What does this button do?"
> Interviewer: "Just imagine it would take you to your dashboard."
> Customer: "I don't really understand what I'm looking at."
>
> **Friday Interview 5:** Same confusion. All feedback is about the prototype quality, not the concept.
>
> *Result:* No signal on whether the idea works. Just learned that wireframes are confusing.

**Correct (Goldilocks quality):**

> **Thursday:** Team builds a Keynote/Figma prototype with:
> - Real (but placeholder) content — actual words, not lorem ipsum
> - Actual images — stock photos that fit the context
> - Clickable flow — customers can tap through the critical path
> - Realistic UI — looks like a real app, even if it's static
>
> **Friday Interview 1:**
> Customer forgets it's not real. "Oh, I'd click here and then... wait, can I go back?"
>
> Feedback is about the concept: "I love this part, but I'm confused about why I'd use this feature."
>
> *Result:* Clean signal on the idea. Team can throw it away because they didn't over-invest.

**Why it matters:**

The prototype is a prop for a conversation, not the product. Goldilocks quality means:
- Customers suspend disbelief
- Feedback is about the concept, not the fidelity
- Team can pivot without mourning their "beautiful" work
- You can actually finish in one day
