---
title: Not Every Problem Needs a Sprint
impact: CRITICAL
tags: planning, problem-selection, prerequisites
---

## Not Every Problem Needs a Sprint

Design Sprints work for big, risky, uncertain questions. Using one for small optimizations or obvious solutions wastes a week of your team's time.

**Incorrect (wrong problem for a sprint):**

> **Sprint Challenge:** "How can we improve the checkout button conversion rate?"
>
> **Monday:** Team maps the checkout flow. Everyone already knows it.
>
> **Tuesday:** Sketches are all minor variations — different button colors, copy tweaks, icon placements.
>
> **Friday:** Customers don't notice the differences. "They all seem fine."
>
> *Result:* Five days to learn you should just run an A/B test.

**Correct (right problem for a sprint):**

> **Sprint Challenge:** "Should we pivot from B2B to B2C? What would a consumer version look like?"
>
> **Monday:** Map reveals team has completely different assumptions about consumer behavior.
>
> **Tuesday:** Sketches show radically different approaches — some are marketplaces, some are direct, some are freemium.
>
> **Friday:** Three consumers love one approach, two are confused. Clear pattern emerges about what positioning resonates.
>
> *Result:* Five days to get real signal on a strategic bet that would otherwise take months to test.

**Why it matters:**

Sprints are expensive — they cost a week of your best people's time. Use them for high-stakes questions where you have genuine uncertainty. For small optimizations, just ship and measure.

**Good sprint problems:**
- New product direction
- Major feature bets
- Entering new markets
- Behavioral change requirements

**Bad sprint problems:**
- UI polish
- Incremental improvements
- Problems with obvious solutions
- Pure technical challenges
