---
name: growth-loops
description: Use when asked to "growth loops", "build a growth engine", "design a viral loop", "create a content loop", "move beyond paid acquisition", or "why isn't growth compounding". Helps design self-reinforcing growth systems where output becomes input. The Growth Loops framework (from Brian Balfour / Reforge and Elena Verna) shifts thinking from linear funnels to compounding loops.
---

# Growth Loops

## What It Is

Growth Loops is a framework for building sustainable, compounding growth. The core insight: **the best growth systems are loops, not funnels — where the output of one cycle becomes the input for the next.**

Traditional growth thinking focuses on funnels: acquire users at the top, optimize conversion through stages, and measure output at the bottom. But funnels are linear. You pour effort in, you get results out, and then you start over. Loops are different: each cycle generates the fuel for the next cycle.

The key shift: Move from asking "How do we get more users?" to asking "How does each user we acquire generate more users?"

## When to Use It

Use Growth Loops when you need to:

- **Design your core growth engine** before or after product-market fit
- **Move beyond paid acquisition** to more sustainable growth
- **Understand why growth isn't compounding** despite acquisition efforts
- **Build virality, content, or sales loops** into your product
- **Evaluate distribution strategies** for a new product or feature
- **Diagnose why your "growth team" isn't producing results**
- **Plan how to capitalize on new distribution platforms** (like ChatGPT)

## When Not to Use It

- You haven't validated that anyone wants your product (find PMF first)
- You're optimizing micro-conversions without a growth model
- You're looking for "growth hacks" rather than systematic growth
- Your product has no natural mechanism for users to generate more users

## Patterns

Detailed examples showing how to apply Growth Loops correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [funnels-vs-loops](patterns/funnels-vs-loops.md) | Funnels are linear and exhausting; loops compound and sustain |
| [paid-acquisition-not-a-loop](patterns/paid-acquisition-not-a-loop.md) | Paid growth doesn't compound — it's buying users, not building an engine |
| [founder-led-growth-first](patterns/founder-led-growth-first.md) | You can't outsource finding your growth model to a growth team |
| [kindle-before-fire](patterns/kindle-before-fire.md) | Non-scalable hacks exist only to unlock scalable loops |
| [product-must-own-growth](patterns/product-must-own-growth.md) | Growth can't be a marketing-only function — product must own pipeline |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [loop-types](patterns/loop-types.md) | Content loops, viral loops, sales loops — each has different mechanics |
| [earned-over-paid](patterns/earned-over-paid.md) | Invest 80%+ in earned/owned channels, not paid |
| [platform-cycles](patterns/platform-cycles.md) | New platforms open, then close — time your bets correctly |
| [seven-users-threshold](patterns/seven-users-threshold.md) | Magic numbers signal readiness for enterprise conversations |
| [velocity-over-volume](patterns/velocity-over-volume.md) | Changes in growth rate matter more than absolute numbers |
| [word-of-mouth-requires-delight](patterns/word-of-mouth-requires-delight.md) | Viral loops only work when you blow their socks off |
| [one-primary-loop](patterns/one-primary-loop.md) | One loop dominates; others supplement but won't save you |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [monetization-awareness](patterns/monetization-awareness.md) | 75% of freemium users don't know what you're selling |
| [growth-team-timing](patterns/growth-team-timing.md) | Hire growth only when you have volume to experiment on |
| [pqa-not-pql](patterns/pqa-not-pql.md) | Focus on qualifying accounts, not individual leads |


## Deep Dives

Read only when you need extra detail.

- `references/growth-loops-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Reforge Programs:**
- Growth Series — the comprehensive deep dive
- Product-Led Growth course — PLG and PLS specifics
- Experimentation program — optimizing loop steps

**Key Thinkers:**
- Brian Balfour (Reforge) — loops framework, platform cycles
- Elena Verna — product-led sales, PQA, B2B growth
- Casey Winters — kindle vs. fire strategies, growth models
- Andrew Chen — platform effects, viral loops

**Other:**
- Alex Rampell's essay on distribution vs. product
- Casey Winters' writing on product-led sales loops
- Elena Verna's Substack on PLG and PLS
