---
title: Funnels Are Linear; Loops Compound
impact: CRITICAL
tags: mental-model, strategy, fundamentals
---

## Funnels Are Linear; Loops Compound

Funnel thinking leads to exhausting, linear growth. Loop thinking leads to sustainable, compounding growth. This is the foundational mindset shift.

**Incorrect (funnel thinking):**

> **Growth Strategy for SaaS Product:**
> - Top of funnel: Run Facebook ads, LinkedIn ads, Google ads
> - Middle of funnel: Nurture with email sequences
> - Bottom of funnel: Sales closes deals
> - Repeat: Pour more money into ads next month
>
> **Problem:** Every month we have to spend MORE on ads to hit the same targets. CAC keeps rising. We're on a treadmill.

**Correct (loop thinking):**

> **Growth Strategy for SaaS Product:**
> - User signs up (input)
> - User creates and shares reports with stakeholders (action)
> - Stakeholders see reports, want their own access (output → new input)
> - Each user generates 0.3 new users over their lifetime
>
> **Result:** Growth compounds. The cost to acquire user #10,000 is lower than user #1,000 because the loop is generating its own fuel.

**Why it matters:**

Funnels require you to constantly feed them. When budget runs out, growth stops. Loops generate their own input — each cycle fuels the next. This is the difference between companies that exhaust themselves and companies that achieve escape velocity.
