---
title: Hire Growth Only When You Have Volume
impact: MEDIUM
tags: hiring, growth-team, timing
---

## Hire Growth Only When You Have Volume

Growth teams optimize and experiment. Both require volume. Hiring growth before you have enough users to experiment on is expensive failure.

**Incorrect (premature growth hire):**

> **Company Stage:** $200K ARR, 500 monthly active users
>
> **Decision:** "We need to accelerate growth. Let's hire a Head of Growth."
>
> **What happens:**
> - Growth lead tries to run experiments
> - A/B tests need 1,000+ users per variant for significance
> - With 500 MAU, experiments take 3 months each
> - Growth lead can only run 4 experiments per year
> - No learnings accumulate. Progress is glacial.
> - Growth lead frustrated, leaves after 18 months.

**Correct (volume-appropriate timing):**

> **When to hire growth:**
> - You have clear product-market fit (retention curves flatten)
> - You have volume to run experiments (thousands of users minimum)
> - You've identified at least one working loop (via founder-led growth)
> - You need help scaling what's working, not finding what works
>
> **Rule of thumb:**
> - <$1M ARR: Founder-led growth. No growth hire.
> - $1-5M ARR: Maybe one growth PM, focused on scaling proven loop
> - $5M+ ARR: Build growth team to optimize and expand loops
>
> **First hire should scale, not discover.**

**Why it matters:**

Growth is a scaling function, not a discovery function. Founders discover the initial loops. Growth teams optimize and scale them. Hiring growth without volume or proven loops is like hiring a chef before you have a kitchen.
