---
title: Know Your Loop Type — Content, Viral, or Sales
impact: HIGH
tags: strategy, loop-types, fundamentals
---

## Know Your Loop Type — Content, Viral, or Sales

Different products have different natural loop types. Forcing the wrong loop on your product wastes resources. Identify which loop matches your product's inherent behavior.

**Incorrect (forcing wrong loop type):**

> **Enterprise Security Tool:**
> - "Let's make it viral! Add sharing buttons everywhere!"
> - Result: Nobody shares security audits. 0.01 K-factor.
>
> - "Let's do content marketing! Blog about security!"
> - Result: Blog gets traffic, but no conversion. Wrong audience.
>
> **Years of wasted effort** on loops that don't match the product.

**Correct (matching loop to product nature):**

> **Enterprise Security Tool Analysis:**
> - Q: Do users naturally share or invite others? → No, security is sensitive
> - Q: Does usage create discoverable content? → No, reports are private
> - Q: Does individual usage signal enterprise readiness? → YES
>
> **Natural loop: Product-Led Sales**
> - Security engineer uses free tier to audit their code
> - Usage shows they're scanning repos, adding team members
> - At 7+ users and 1000+ scans/month = PQA threshold
> - Sales engages enterprise buyer with usage data as proof

**The three loop types:**

1. **Viral loops**: Users invite users (Dropbox, Slack, Figma)
2. **Content loops**: Usage creates discoverable content (Pinterest, Eventbrite, Coda)
3. **Sales loops**: Usage creates qualified pipeline (Amplitude, Miro, MongoDB)

**Why it matters:**

You can't force virality on a product that isn't inherently shareable. You can't build content loops if usage doesn't create indexable content. Match your strategy to your product's natural behavior.
