---
title: Focus on Qualifying Accounts, Not Just Leads
impact: MEDIUM
tags: pqa, pql, b2b, sales
---

## Focus on Qualifying Accounts, Not Just Leads

In enterprise B2B, the buyer is rarely in your user base. Focus on qualifying accounts (PQA) first, then find or attract the buyer.

**Incorrect (PQL-only approach):**

> **Lead Qualification Model:**
> - User signs up → gets lead score
> - High usage → SQL → sales reaches out to that user
>
> **Problem:** User is a junior PM with no budget authority
>
> **Sales conversation:**
> - Sales: "Ready to buy our enterprise plan?"
> - User: "I love the product but I can't approve $50K. I have no idea who can."
> - Sales: "This lead is garbage."

**Correct (PQA-first approach):**

> **Account Qualification Model:**
> - Aggregate usage at account level (all users from company X)
> - Define PQA threshold: 7+ users, velocity spike, feature breadth
> - Check: Is there a buyer (PQL) in the account?
>   - If yes: Sales engages the buyer with usage data
>   - If no: Marketing finds/attracts the buyer via ABM
>
> **The distinction:**
> - **PQA:** Account is ready for enterprise conversation (usage-based)
> - **PQL:** There's a person in the account who can buy (role-based)
>
> **Reality:** 90% of PQAs don't have a PQL. Marketing must connect buyer to usage.

**Why it matters:**

User doesn't equal buyer, especially in enterprise. If you only focus on PQL, you miss accounts with strong usage but no buyer contact. If you only focus on PQA, sales wastes time reaching out to users with no authority. You need both, and PQA comes first.
