---
title: The Magic Number Is Often 7 Users
impact: HIGH
tags: pqa, b2b, thresholds
---

## The Magic Number Is Often 7 Users

In B2B product-led growth, 7 users in an account is often the threshold where enterprise conversations become viable. This pattern appears across many companies.

**Incorrect (engaging too early):**

> **Sales Engagement Rules:**
> - Any account with 2+ users → SDR reaches out
> - Result: Users annoyed, "Why is sales calling me? I have no budget."
> - Sales marks PLG leads as "garbage quality"
> - Product-led sales motion fails
>
> **Or engaging based on wrong signals:**
> - Anyone who views pricing page → outbound email
> - Result: Students, competitors, and tire-kickers get spammed

**Correct (threshold-based engagement):**

> **PQA Definition (example from Miro/Amplitude patterns):**
> - 7+ users in account ← Magic number threshold
> - AND velocity change (added 5 users this week vs 1/week before)
> - AND feature breadth (using collaboration features, not just individual)
> - AND behavioral signal (admin change, pricing page, terms of use page)
>
> **Why 7?**
> - Validates there's team-level adoption, not just individual
> - Similar pattern to "7 friends in 10 days" at Facebook
> - Enough users that enterprise conversation makes sense
>
> **Sales engagement:** Only when account crosses PQA threshold. Sales reaches out with context: "I see your team of 8 is actively using X feature..."

**Why it matters:**

Engaging too early destroys user trust and wastes sales resources. Engaging too late misses the window. The magic number varies by product, but 7 is a common starting point. Build feedback loops with sales to refine your specific threshold.
