---
title: Velocity Matters More Than Volume
impact: HIGH
tags: metrics, signals, pqa
---

## Velocity Matters More Than Volume

Changes in growth rate (velocity) are more predictive than absolute numbers (volume). A sudden spike in activity is a stronger signal than steady usage.

**Incorrect (volume-only metrics):**

> **PQA Definition:**
> - Account has 10+ users → qualified
> - Account has 1000+ events → qualified
>
> **Problem:** An account with 10 users that's been flat for 6 months is very different from an account that went from 2 to 10 users this week. Same volume, completely different signal.
>
> **Result:** Sales chases stale accounts. Misses hot ones that are actively expanding.

**Correct (velocity-aware metrics):**

> **PQA Definition:**
> - Account added 5+ users in the last 7 days (velocity spike)
> - OR account's weekly event volume increased 3x from prior week
> - OR admin changed + new integrations added (behavioral velocity)
>
> **Why velocity?**
> - Velocity indicates something changed — likely evaluation or expansion
> - Volume alone doesn't tell you "is now the right time?"
> - Velocity identifies the moment of maximum receptivity
>
> **Example:**
> - Account A: 50 users, added 1 user last month → Low priority
> - Account B: 8 users, added 6 users this week → HIGH priority (velocity signal)

**Why it matters:**

Volume tells you how big. Velocity tells you "is now the right time?" Sales engagement is about timing. An account showing velocity changes is actively evaluating, expanding, or championing internally. That's when intervention adds value.
