---
name: hierarchy-of-engagement
description: Use when asked to "define our core action", "North Star metric", "accruing benefits", "improve retention mechanics", "hierarchy of engagement", or "Sarah Tavel framework". Helps consumer products identify the actions and benefits that drive long-term retention. The Hierarchy of Engagement framework (created by Sarah Tavel at Benchmark) maps progression from core action to mounting loss.
---

# Hierarchy of Engagement

## What It Is

The Hierarchy of Engagement is a three-level framework for building consumer products that retain users and create defensibility. The core insight: **retention comes from making the product better the more you use it, so users have more to lose by leaving.**

Most consumer products fail not because they lack users, but because they lack retention. Getting someone to sign up is one thing; getting them to stay is everything. This framework provides a systematic approach to building products where engagement compounds over time.

The key shift: Move from asking "How do we get more users?" to asking "How do we make each user's experience improve the more they use us?"

## Response Posture

- Apply the framework directly to the user's product.
- Never mention the repository, skills, SKILL.md, patterns, or references.
- Do not run tools or read files; answer from the framework.
- Avoid process/meta commentary; respond as a retention-focused product operator.

## When to Use It

Use the Hierarchy of Engagement when you need to:

- **Define your North Star metric** (what action matters most?)
- **Improve retention** in a consumer or social product
- **Build product stickiness** beyond features alone
- **Create switching costs** that protect against competitors
- **Design your onboarding/activation** flow
- **Evaluate product-market fit** through engagement quality
- **Prioritize features** that drive compounding value

## When Not to Use It

Don't apply this framework when:

- Building B2B enterprise software (different retention dynamics)
- The product is transactional by nature (one-time purchase)
- There's no meaningful "use over time" pattern
- You're optimizing for viral acquisition before proving retention
- Your product has no user-generated content or personalization opportunity

## Patterns

Detailed examples showing how to apply the Hierarchy of Engagement correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [wrong-core-action](patterns/wrong-core-action.md) | Your core action must predict retention, not just engagement |
| [benefit-doesnt-accrue](patterns/benefit-doesnt-accrue.md) | The product must get better the more someone uses it |
| [no-mounting-loss](patterns/no-mounting-loss.md) | Users need something to lose by leaving |
| [skipping-level-one](patterns/skipping-level-one.md) | You can't build retention without first nailing the core action |
| [vanity-engagement](patterns/vanity-engagement.md) | Measuring opens and sessions instead of meaningful actions |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [forcing-level-three](patterns/forcing-level-three.md) | Not every product can or should have virality loops |
| [activation-without-education](patterns/activation-without-education.md) | Users must understand the mental model before they can engage |
| [anonymous-users](patterns/anonymous-users.md) | Pure anonymity prevents accruing benefit and mounting loss |
| [geographic-spray](patterns/geographic-spray.md) | Growing everywhere means retaining nowhere |
| [youtube-subscribe-example](patterns/youtube-subscribe-example.md) | When one action serves both sides of a network |
| [pinterest-pinning](patterns/pinterest-pinning.md) | How Pinterest discovered pinning was the core action |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [evernote-trap](patterns/evernote-trap.md) | Strong Level 2 can't compensate for missing Level 3 |
| [comparing-to-mature-products](patterns/comparing-to-mature-products.md) | Don't build the full expression before the foundation |


## Deep Dives

Read only when you need extra detail.

- `references/hierarchy-of-engagement-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Writing:**
- [The Hierarchy of Engagement](https://sarahtavel.medium.com/the-hierarchy-of-engagement-5803bf4e6cfa) by Sarah Tavel — the original framework
- [The Hierarchy of Engagement, Expanded](https://sarahtavel.medium.com/the-hierarchy-of-engagement-expanded-648329d60804) by Sarah Tavel — deeper on Level 2 and 3

**Related:**
- *Hooked* by Nir Eyal — habit-forming product design (complements Level 1)
- Lenny Rachitsky's North Star Metric compilation — examples of core actions across companies

**Podcast:**
- [Sarah Tavel on Lenny's Podcast](https://www.lennyspodcast.com/) — source conversation for this framework
