---
title: Users Must Understand the Mental Model First
impact: HIGH
tags: activation, onboarding, NUX, mental-model, level-1
---

## Users Must Understand the Mental Model First

Users can't complete the core action if they don't understand what they're supposed to be doing. Dropping users into your product without teaching them the mental model leads to confusion and churn.

**Incorrect (skipping the explanation):**

> **Pinterest Early NUX Experiment:**
>
> Pinterest tested a new user experience that skipped explaining pinning. Users signed up, and their feed "magically appeared" — they saw content immediately without understanding what pinning was or why they should do it.
>
> *What happened*: Users scrolled passively. They didn't pin anything. They didn't build boards. They experienced Pinterest like a read-only magazine.
>
> *Result*: Retention dropped because users never discovered the core action.

**Correct (teaching the mental model):**

> **Pinterest NUX - The Fix:**
>
> "Your job in onboarding is to help users understand:
>
> 1. What is Pinterest for? (Discovering and saving ideas)
> 2. What is the core action? (Pinning things to boards)
> 3. What happens when you do it? (You build a collection you can return to)
>
> Only THEN do you show them the feed. They need to understand they're here to actively curate, not passively consume."
>
> The activation flow should:
> - Explain the purpose before showing content
> - Get users to complete the core action during onboarding
> - Show them the value of that action immediately

**Why it matters:**

Many products fail activation because they assume users will figure it out. They won't. If someone uses your product but never completes the core action, something is missing from their experience — usually, it's understanding what they were supposed to do in the first place.
