---
title: Don't Build the Full Expression Before the Foundation
impact: MEDIUM
tags: scope, sequencing, maturity, early-stage
---

## Don't Build the Full Expression Before the Foundation

Consumer founders see TikTok, Instagram, or Roblox and try to build all their features from day one. But those products built their complexity over years, after proving their core action worked.

**Incorrect (building the full vision immediately):**

> **New Social App PRD:**
>
> "We're building the next Instagram. Feature set for launch:
> - Stories with AR filters
> - Reels-style short video
> - Live streaming
> - Shopping integration
> - Creator monetization tools
> - Group messaging
> - Explore algorithm
>
> We need feature parity to compete!"
>
> *What happens*: Team spends 18 months building. Launches with a bloated product. Users don't understand what they're supposed to do. No clear core action. Everything is mediocre.

**Correct (nail the foundation first):**

> **New Social App Strategy:**
>
> "What is the ONE thing we do? What's our core action?
>
> Month 1-3: Build the simplest version that lets users complete that action
> - No stories, no reels, no shopping
> - Just the core loop
>
> Prove it works:
> - Do users complete the core action?
> - Do they come back?
>
> Month 4-8: Build Level 2 around the core action
> - How does the product get better with use?
> - What do users accumulate?
>
> Only then: Consider Level 3 features"
>
> Instagram launched as a photo-sharing app with filters. Stories came 6 years later. Reels came 10 years later.

**Why it matters:**

The biggest mistake Sarah Tavel sees is founders comparing themselves to the "full expression" of mature products. Those products earned the right to be complex by first being simple and proving retention. You can't skip that step, no matter how much funding you have.
