---
title: Users Need Something to Lose by Leaving
impact: CRITICAL
tags: mounting-loss, switching-costs, level-2, retention
---

## Users Need Something to Lose by Leaving

Accruing benefit is only half of Level 2. You also need mounting loss — accumulated value that users can't take with them. Without mounting loss, users can leave and start fresh without penalty.

**Incorrect (nothing to lose by switching):**

> **Music Streaming Service:**
>
> "Our app has the best discovery algorithm. Users love finding new music with us."
>
> *The problem*: When a competitor offers a free trial:
> - User exports their playlist (all platforms support this now)
> - They start fresh with competitor
> - Within weeks, the new algorithm learns their taste too
> - They've lost nothing meaningful
>
> *Result*: Users churn to whoever has the best deal or newest features.

**Correct (accumulated value that doesn't transfer):**

> **What creates real mounting loss:**
>
> - **Social graph**: Your followers don't come with you (Instagram, YouTube)
> - **Reputation**: Your reviews, ratings, and credibility are platform-locked (Airbnb, eBay)
> - **Identity**: Your username, history, and persona stay behind (Reddit, Twitter)
> - **Learned algorithms**: The system that knows your taste took years to train
> - **Created content in context**: Your pins make sense on your boards, not exported as files
>
> **YouTube creators** have massive mounting loss: their subscriber base. Even if they can download their videos, they can't export 10 million subscribers to a new platform. That's mounting loss.

**Why it matters:**

Data portability regulations are making some forms of mounting loss weaker (you can export your data). Products need to create value in forms that inherently don't transfer — social graphs, reputation systems, and algorithmic personalization that requires retraining.
