---
title: How Pinterest Discovered Pinning Was the Core Action
impact: HIGH
tags: core-action, case-study, pinterest, analysis, metrics
---

## How Pinterest Discovered Pinning Was the Core Action

Pinterest's journey to identifying "pinning" as their core action demonstrates how to find yours: combine bottom-up data analysis with top-down product intuition.

**The Problem:**

> Pinterest had many possible actions to optimize for:
> - Liking content
> - Following other users
> - Clicking through to source websites
> - Time spent on site
> - Pinning/repinning to boards
>
> *Experiments gave conflicting signals*: Some metrics went up, others went down. What should they actually be optimizing for?

**The Bottom-Up Analysis:**

> "We looked at every action and asked two questions:
>
> 1. What percentage of users complete this action?
> 2. If you do this action in Week 1, what's the probability you return Week 2?
>
> | Action | % Who Do It | Week 2 Return Rate |
> |--------|-------------|-------------------|
> | View feed | 80% | 40% |
> | Like | 45% | 55% |
> | Follow | 30% | 60% |
> | Click through | 50% | 50% |
> | **Pin/Repin** | 35% | **>90%** |
>
> Pinning was the clear outlier. Users who pinned almost always came back."

**The Top-Down Intuition:**

> "What is Pinterest, really? It's a place to discover and save ideas.
>
> The mental model is: Find something interesting, save it to a board, return to your boards later.
>
> Pinning IS the product. If users aren't pinning, they're using Pinterest wrong — they're treating it like a magazine to browse, not a tool to collect."

**The Result:**

> "We defined our North Star as 'Weekly Active Pinners' (WAPs).
>
> - Our NUX had to teach pinning
> - Our feed had to encourage pinning
> - Our success = users pinning, not just browsing
>
> This clarity let us make every product decision through one lens: Does this increase pinning?"

**Why it matters:**

Most products have many things users *can* do. The core action is the one thing they *should* do. Pinterest could have optimized for time on site and become a passive browsing experience. By identifying pinning as the core action, they built a fundamentally different and much more retentive product.
