---
title: You Cannot Skip to Level 2 or 3
impact: CRITICAL
tags: sequence, core-action, level-1, foundation
---

## You Cannot Skip to Level 2 or 3

Many teams try to add stickiness features (Level 2) or viral loops (Level 3) before proving the core action works. This is like adding a second floor before the foundation is set. The levels must be built in sequence.

**Incorrect (jumping ahead):**

> **New Social App Launch Plan:**
>
> "Week 1-2: Launch with invite-only virality mechanics
> Week 3-4: Add streaks and gamification for retention
> Week 5-6: Build sharing features to drive growth loops
>
> We need to move fast and build defensibility before competitors copy us."
>
> *What happens*: Users sign up through invites, see a confusing product, don't understand what they're supposed to do, and churn. The viral loops and streaks don't matter because there's no core action holding people.
>
> *Result*: The growth loop pumps in users who immediately leak out.

**Correct (sequential foundation):**

> **New Social App Launch Plan:**
>
> "Phase 1: Define and prove the core action
> - What is the one thing users should be doing?
> - Does completing that action predict Week 2 return?
> - Can we get 40% of new users to complete it?
>
> Phase 2: Build accruing benefit around the core action
> - How does the product improve for users who keep doing this?
> - What do they accumulate that makes leaving costly?
>
> Phase 3: Create loops (only once 1 and 2 work)
> - Does the core action create value for other users?
> - Can we build growth loops without compromising the core?"

**Why it matters:**

The biggest mistake Sarah Tavel sees founders make is trying to build the "full expression" of their product (comparing themselves to Instagram or TikTok) before nailing the foundation. Those products took years to add their viral mechanics — they started with a core action that worked.
