---
title: Measure Actions That Predict Retention, Not Vanity Metrics
impact: CRITICAL
tags: metrics, vanity-metrics, north-star, measurement
---

## Measure Actions That Predict Retention, Not Vanity Metrics

DAU, app opens, time on site, and sessions are vanity metrics unless they correlate with retention. Many products optimize for these numbers while actual retention suffers.

**Incorrect (vanity metrics driving decisions):**

> **Consumer App Dashboard:**
>
> Key Metrics:
> - DAU: 500K (up 20% MoM!)
> - Sessions per user: 4.2/day
> - Time on app: 28 min/day
> - Push notification open rate: 35%
>
> "Our engagement is incredible! Users love us!"
>
> *What they're not seeing*: 30-day retention is 15%. Users open the app a lot in Week 1, then disappear. The push notifications are annoying them into opening, not engaging.

**Correct (retention-predictive metrics):**

> **Consumer App Dashboard:**
>
> Core Action Metrics:
> - % of users completing core action in Week 1: 35%
> - Week 2 return rate for core action completers: 78%
> - Week 2 return rate for non-completers: 12%
>
> Accruing Benefit Metrics:
> - Avg. items saved per retained user: 47
> - Users with 10+ items: 82% still active at 90 days
> - Users with <5 items: 23% still active at 90 days
>
> "We know exactly what predicts retention. Our job is to get more users to complete the core action and accumulate value."

**Why it matters:**

At Pinterest, they measured everything — likes, follows, time on site, clicks. But only when they identified *pinning* as the action that predicted retention could they focus. A user who pinned had >90% chance of returning; one who just browsed had much lower. That clarity let them design everything — activation, features, metrics — around the right action.
