---
title: When One Action Serves Both Sides of a Network
impact: HIGH
tags: core-action, two-sided, network, youtube, example
---

## When One Action Serves Both Sides of a Network

The best core actions work for both sides of a two-sided network. YouTube's subscribe button creates accruing benefit and mounting loss for both creators AND viewers.

**Incorrect (asymmetric value):**

> **Video Platform Core Action Candidates:**
>
> - "Watch a video" — good for viewers, nothing for creators
> - "Upload a video" — good for creators, nothing for viewers
> - "Like a video" — mild signal, doesn't create real connection
>
> *Problem*: Each of these only serves one side. You need different strategies for each side of the marketplace.

**Correct (symmetric value in one action):**

> **YouTube's Subscribe Button:**
>
> **For Creators:**
> - Subscribers = audience you own
> - More subscribers = more guaranteed views on new content
> - Accruing benefit: Audience grows over time
> - Mounting loss: You can't export your subscribers to a new platform
>
> **For Viewers:**
> - Subscriptions = curated content sources
> - More subscriptions = better personalized home feed
> - Accruing benefit: Your feed gets better at showing what you want
> - Mounting loss: Starting fresh means re-finding all your favorite creators
>
> "One action creates Level 2 for both sides of the network. That's why it became YouTube's North Star."

**Why it matters:**

Many social products are really marketplaces (creators and consumers). YouTube's genius was finding an action where both sides build value through the same mechanism. When you can find this kind of symmetric core action, you've simplified your product dramatically — one metric drives everything.
