# Hierarchy of Engagement Playbook

Use this reference only when you need deeper guidance beyond the overview and patterns.

## The Three Levels

The Hierarchy of Engagement has three sequential levels. Each level builds on the previous one. You cannot skip levels.

```
                    LEVEL 3: VIRTUOUS LOOPS
                    ┌─────────────────────┐
                    │ Users make product  │
                    │ better for others   │
                    │ (Network effects)   │
                    └─────────┬───────────┘
                              │
                    LEVEL 2: ACCRUING BENEFIT + MOUNTING LOSS
                    ┌─────────┴───────────┐
                    │ Product gets better │
                    │ with use; leaving   │
                    │ means losing value  │
                    └─────────┬───────────┘
                              │
                    LEVEL 1: CORE ACTION
                    ┌─────────┴───────────┐
                    │ Users complete the  │
                    │ single most valuable│
                    │ action repeatedly   │
                    └─────────────────────┘
```

### Level 1: Identify and Drive the Core Action

The core action is the single most important thing a user can do in your product. It's not just any engagement — it's the action most predictive of long-term retention.

**Examples of core actions:**

| Product | Core Action | Not the Core Action |
|---------|-------------|---------------------|
| Pinterest | Pin/Repin something | View feed, like, follow |
| Snapchat | Send a snap | Open app, view stories |
| YouTube | Subscribe to a creator | Watch a video |
| Spotify | Save/follow an artist or playlist | Listen to a song |

**How to find your core action:**

1. **Bottom-up analysis**: List every action users can take. For each action, measure:
   - What percentage of users complete it?
   - If they do it in Week 1, what's the probability they return in Week 2?
   - Rank actions by retention correlation

2. **Top-down intuition**: What is the mental model of your product? What is the user *supposed* to be doing here? The core action should embody the product's purpose.

At Pinterest, both approaches converged on the same answer: pinning. Users who pinned had >90% probability of returning the next week. And pinning is what Pinterest *is* — discovering and saving ideas.

**The test**: If a user uses your product but doesn't complete the core action, there's something missing from their experience.

### Level 2: Create Accruing Benefit and Mounting Loss

Once users are completing the core action, the next challenge is making them stick. The test for Level 2: **the product should get better the more you use it, and you should have more to lose by leaving.**

**Accruing Benefit**: The product becomes more valuable with use.

| Product | How Benefit Accrues |
|---------|---------------------|
| Pinterest | Your boards become a curated collection of your interests |
| Evernote | Your notes become a searchable archive of everything you know |
| Spotify | Your Discover Weekly gets better at predicting what you like |
| YouTube | Your home feed learns what content you want |

**Mounting Loss**: Leaving means losing accumulated value.

| Product | What You Lose by Leaving |
|---------|--------------------------|
| Pinterest | Years of curated boards and saved ideas |
| YouTube (creators) | Your subscriber base and audience |
| LinkedIn | Your professional network and history |
| Instagram | Your followers, photos, and social identity |

**The combination is powerful**: You stay because the product keeps getting better AND because leaving would mean starting over.

**Example: Evernote**

Evernote has exceptional Level 2. The more notes you add, the more valuable your archive becomes. After thousands of notes over years, you can search and find anything. You can never leave — you'd lose your entire external brain.

But Evernote lacks Level 3 (no loops where your usage makes it better for others), which limited their growth ceiling.

### Level 3: Create Virtuous Loops

Level 3 is what creates true defensibility and efficient growth. When users completing the core action makes the product better for other users, you have a virtuous loop.

**The test**: Does my usage make the product better for you?

**Types of virtuous loops:**

1. **Content loops**: My pins make Pinterest better for people with similar interests
2. **Network loops**: My presence on the platform makes it more valuable for my friends
3. **Creator/audience loops**: Creators draw audiences; audiences draw creators (YouTube, TikTok)

**Why Level 3 matters:**

- Products with Level 3 can grow efficiently (users bring other users)
- Products without Level 3 must pay for every user (Evernote's ceiling)
- Level 3 creates real network effects and defensibility

**Not every product can have Level 3.** That's okay — but recognize the implications:
- Without Level 3, you'll need to fund acquisition forever
- Without Level 3, you're vulnerable to competitors who do have it
- Some businesses (like Evernote) can be valuable without Level 3, but they have natural growth limits

## Common Mistakes

### 1. Choosing the wrong core action

Many teams pick an action that feels important but doesn't predict retention. Opens, time on site, and video views feel good but often don't correlate with whether someone comes back.

**How to avoid**: Do the data analysis. What action, when completed in Week 1, predicts return in Week 2?

### 2. Benefits that don't compound

"We have great features" isn't accruing benefit. The product must get *better for that specific user* the more they use it.

**How to avoid**: Ask "What does user X have after 1 year of usage that they didn't have on day 1?"

### 3. No mounting loss

If users can leave and start fresh elsewhere with no penalty, you have no mounting loss. Data portability regulations are making this harder, but there are still forms of value that don't export.

**How to avoid**: Consider what users accumulate that they can't take with them — social graphs, reputation, learned algorithms, created content within your ecosystem.

### 4. Forcing Level 3 when it doesn't fit

Not every product needs or can have network effects. Trying to bolt on social features to a solo-use product often fails (Evernote's collaborative journals).

**How to avoid**: Be honest about what level your product can naturally reach. Level 2 products can be great businesses — just with different growth dynamics.

### 5. Skipping to Level 2 or 3 before nailing Level 1

You can't create retention before you have a core action that works. Many teams try to add stickiness features before proving the core loop.

**How to avoid**: Sequence matters. Get Level 1 working first.

### 6. Not teaching the mental model

If users don't understand what they're supposed to do, they won't complete the core action. Pinterest learned this when a NUX that skipped explaining pinning led to confused, non-retentive users.

**How to avoid**: Your activation flow must teach users what success looks like in your product.

### 7. Growing without focus

Geographic spray (growing via TikTok virality without geographic focus) makes density-dependent products impossible to retain. You get users everywhere but critical mass nowhere.

**How to avoid**: Constrain your growth to where you can achieve density first.

## Applying the Framework: Checklists

### For Product Strategy

- [ ] What is our core action? Have we validated it predicts retention?
- [ ] Does our product get better the more each user uses it?
- [ ] What would a user lose by leaving? Is that loss significant?
- [ ] Do we have loops where user activity improves the product for others?
- [ ] Are we focused on the right level for our current stage?

### For Activation/Onboarding

- [ ] Does our NUX teach users the mental model of the product?
- [ ] Does it lead users to complete the core action?
- [ ] Can we measure activation success by core action completion?
- [ ] Are we showing users the path to accruing benefit early?

### For Metrics Definition

- [ ] Is our North Star metric tied to the core action?
- [ ] Are we measuring actions that predict retention, not vanity metrics?
- [ ] Do our cohort analyses show improvement on the core action over time?
- [ ] Can we see the accruing benefit in user data (more content, more connections, etc.)?

### For Retention Analysis

- [ ] Are users completing the core action repeatedly?
- [ ] Do retained users show evidence of accruing benefit?
- [ ] Do churned users lack indicators of mounting loss?
- [ ] Are we losing users who never reached Level 2?

### For Competitive Strategy

- [ ] What level have our competitors achieved?
- [ ] Do we have stronger Level 2 (more accrued value per user)?
- [ ] Do we have stronger Level 3 (better network effects)?
- [ ] Where is our defensibility if competitors enter?

## Quick Reference

**Level 1 - Core Action**
- The single most important action users take
- Must predict long-term retention
- Found through data analysis + product intuition
- Test: Does completing this action lead to return?

**Level 2 - Accruing Benefit + Mounting Loss**
- Product gets better the more you use it
- Users accumulate value they'd lose by leaving
- Test: What does a 1-year user have that a new user doesn't?

**Level 3 - Virtuous Loops**
- Your usage makes the product better for others
- Creates network effects and efficient growth
- Test: Does my activity improve your experience?

**The Sequence**: You must progress through levels in order. Each level depends on the previous.

---

