---
name: hierarchy-of-marketplaces
description: Use when asked about "marketplace strategy", "chicken and egg problem", "liquidity", "two-sided market", "tipping a marketplace", "GMV growth", or "Sarah Tavel marketplaces". Helps founders and product leaders build defensible marketplace businesses by sequencing supply and demand. The Hierarchy of Marketplaces framework (created by Sarah Tavel / Benchmark) provides a progression from focused launch to market dominance.
---

# Hierarchy of Marketplaces

## What It Is

The Hierarchy of Marketplaces is a framework for building defensible marketplace businesses. The core insight: **GMV is a vanity metric. Happy GMV is what matters.**

Most marketplace founders race to grow GMV as fast as possible, spreading resources thin across markets and categories. This is backwards. The path to a dominant, profitable marketplace requires working through three levels in sequence:

1. **Focus** - Constrain your market to a "thimble" and achieve minimum viable happiness
2. **Tip** - Reach saturation in your focused market until it tips in your favor
3. **Dominate** - Only then expand to adjacent markets and categories

The key shift: Move from asking "How do we grow GMV?" to asking "How do we make both sides of our marketplace so happy they retain?"

## Response Posture

- Apply the framework directly to the user's marketplace.
- Never mention the repository, skills, SKILL.md, patterns, or references.
- Do not run tools or read files; answer from the framework.
- Avoid process/meta commentary; respond as a marketplace operator.

## When to Use It

Use the Hierarchy of Marketplaces when you need to:

- **Launch a new marketplace** and decide where to focus
- **Diagnose why growth is stalling** despite increasing GMV
- **Decide when to expand** to new markets or categories
- **Evaluate marketplace health** beyond top-line metrics
- **Compete against incumbents** with more resources
- **Raise funding** and demonstrate real marketplace value
- **Choose between depth and breadth** in your growth strategy

## When Not to Use It

- You're building a product without two-sided network effects
- You have unlimited capital and no competition (rare)
- The market has no potential for winner-take-most dynamics
- You're optimizing a mature, already-dominant marketplace

## Patterns

Detailed examples showing how to apply the framework correctly. Each pattern shows a common mistake and the correct approach.

### Critical (get these wrong and you've wasted your time)

| Pattern | What It Teaches |
|---------|-----------------|
| [gmv-over-happiness](patterns/gmv-over-happiness.md) | Growing GMV without retention is building on sand |
| [premature-scaling](patterns/premature-scaling.md) | Spreading across markets before proving the model kills you |
| [wrong-side-focus](patterns/wrong-side-focus.md) | Cornering the wrong side of the market at the wrong time |
| [ignoring-tipping-conditions](patterns/ignoring-tipping-conditions.md) | Not all markets can tip - know the conditions first |
| [thimble-not-ocean](patterns/thimble-not-ocean.md) | Focus like a laser beam, not warmth from the sun |

### High Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [take-rate-timing](patterns/take-rate-timing.md) | When to monetize vs. when to subsidize |
| [disintermediation-risk](patterns/disintermediation-risk.md) | Long-term relationships will route around you |
| [homogeneous-supply](patterns/homogeneous-supply.md) | If supply is interchangeable, your flywheel won't spin |
| [happiness-loops](patterns/happiness-loops.md) | Reward good suppliers, churn bad ones automatically |
| [growth-loops](patterns/growth-loops.md) | Find and accelerate the loops that tip your market |
| [repeat-frequency](patterns/repeat-frequency.md) | Low-frequency use cases require different strategies |
| [market-currents](patterns/market-currents.md) | Ride currents of change, don't try to warm the ocean |

### Medium Impact

| Pattern | What It Teaches |
|---------|-----------------|
| [contribution-profit](patterns/contribution-profit.md) | Reinvest market profits to fund expansion |
| [expansion-sequencing](patterns/expansion-sequencing.md) | Go from strength to adjacent strength, not random markets |
| [competitive-focus](patterns/competitive-focus.md) | Better to dominate one market than participate in ten |


## Deep Dives

Read only when you need extra detail.

- `references/hierarchy-of-marketplaces-playbook.md`: Expanded framework detail, checklists, and examples.

## Resources

**Posts by Sarah Tavel:**
- *Hierarchy of Marketplaces* series on Medium
- *The Hierarchy of Engagement* (related framework for consumer products)

**Books:**
- *Platform Revolution* by Parker, Van Alstyne, and Choudary
- *The Cold Start Problem* by Andrew Chen
- *Blitzscaling* by Reid Hoffman (for Level 3 context)

**Other:**
- Lenny Rachitsky's marketplace essays on Lenny's Newsletter
- Bill Gurley's posts on Above the Crowd
- NFX's marketplace content library
