---
title: Better to Dominate One Market Than Participate in Ten
impact: MEDIUM
tags: competition, focus, dominance, market-share
---

## Better to Dominate One Market Than Participate in Ten

Marketplace economics heavily favor the dominant player. Being #1 in one market is worth more than being #3 in ten markets. When a competitor focuses while you spread, they'll win the markets that matter.

**Incorrect (spreading thin against focused competitor):**

> **Scenario:**
> You have $1M to deploy. You spread it across 10 cities ($100K each).
> Competitor has $1M. They put it all into your best 2 cities.
>
> **Result:**
> - Your 10 cities: All at 20% market share, none tipping
> - Their 2 cities: Both at 60% market share, tipping
>
> **What happens next:**
> - They generate contribution profit from tipped cities
> - They raise more capital on the strength of dominance
> - They take your other 8 cities one by one
> - You're eventually squeezed out everywhere

**Correct (focused competition):**

> **Scenario:**
> Same $1M budget. You recognize the competition is focusing.
>
> **Strategic choice:**
> "We can't win everywhere. We're going all-in on 2 markets where we have the strongest position. We'll dominate those, generate profit, and expand from strength."
>
> **Trade-off acknowledged:**
> "We're conceding 8 potential markets to focus on 2. But owning 2 markets is worth more than participating in 10."
>
> **Result:**
> - Your 2 markets: 70% share, tipping, profitable
> - Their 2 markets: 60% share, tipping
> - 6 markets: Contested, neither dominant
>
> A focused competitor took some markets. But you have a defensible position, not a sprawling vulnerability.

**The OLX insight:**

The more dominant a marketplace is relative to #2, the more profitable it becomes. This isn't linear - 80% share isn't 2x better than 40% share, it's exponentially better because you control pricing, demand comes to you by default, and suppliers have no alternative.

| Market share | Economics |
|--------------|-----------|
| 80%+ | Highly profitable, pricing power |
| 50-60% | Profitable but fighting for share |
| 30-40% | Marginally profitable, heavy competition |
| <30% | Likely unprofitable, grinding |

**Why it matters:**

The goal isn't to be present in many markets - it's to dominate some markets. A marketplace with dominant share in 5 markets is worth more than one with middling share in 50. When you're spread thin, a focused competitor will beat you everywhere over time.
