---
title: Reinvest Market Profits to Fund Expansion
impact: MEDIUM
tags: unit-economics, expansion, profitability, capital
---

## Reinvest Market Profits to Fund Expansion

Each market you tip should generate contribution profit that funds the next expansion. If tipped markets aren't profitable, you're just spreading losses across more geographies.

**Incorrect (subsidizing expansion with venture capital):**

> **Marketplace expansion strategy:**
> "We're live in 15 cities. We're raising a $50M Series C to launch in 30 more cities next year."
>
> **Unit economics by city:**
> - No city is contribution-profit positive
> - Best city: -15% margin
> - Worst city: -45% margin
> - "We'll optimize margins after we hit scale"
>
> **What happens:**
> - Each expansion burns more capital
> - No cities improve because resources spread thin
> - Series D becomes essential, dilution increases
> - Market downturn makes Series D impossible
> - Company collapses despite 45-city footprint

**Correct (profitable markets fund expansion):**

> **Marketplace expansion strategy:**
> "We're live in 8 cities. Our first 3 cities (Austin, San Antonio, Houston) are now contribution-profit positive at 12-18% margins. We're using that profit to fund expansion to Dallas, then the rest of Texas."
>
> **Unit economics by city cohort:**
> - First 3 cities: +15% average margin
> - Next 3 cities: Breakeven
> - Newest 2 cities: -10% (expected, on track)
>
> **Expansion model:**
> - Each new city is funded by profits from tipped cities
> - We raise capital to accelerate, not to survive
> - If funding dries up, we're still a profitable business in our core markets

**The contribution profit flywheel:**

```
Tip Market A → Generate profit
                    ↓
            Fund launch in Market B
                    ↓
            Tip Market B → Generate more profit
                    ↓
            Fund launches in Markets C & D
                    ↓
            Repeat, expanding faster each cycle
```

**Why it matters:**

Venture capital lets you accelerate the timeline, but shouldn't be the only thing keeping the company alive. If your tipped markets don't generate profit, you don't have a repeatable model - you have a subsidized experiment. The question to answer: "If funding disappeared tomorrow, could our best markets sustain the company?"
