---
title: Expand from Strength to Adjacent Strength
impact: MEDIUM
tags: expansion, sequencing, playbook, adjacency
---

## Expand from Strength to Adjacent Strength

Your playbook won't work everywhere equally. Expand to markets similar to your wins, not random markets that happen to be big. Go from strength to strength.

**Incorrect (expanding to big random markets):**

> **Food delivery startup:** "We've tipped the suburbs of Dallas. For our next market, we're going to NYC - biggest market, most potential revenue."
>
> **Why this fails:**
> - NYC has different dynamics (density, existing delivery fleets, entrenched competitors)
> - Their Dallas playbook (suburbs, restaurant partnerships, reliability) won't transfer
> - They're restarting from scratch in a harder market
> - Resources split between defending Dallas and learning NYC
>
> **Result:** Mediocre in both markets.

**Correct (expanding to adjacent markets):**

> **Food delivery startup:** "We've tipped the suburbs of Dallas. Next markets:
> 1. **Houston suburbs** - Same playbook, similar demographics, we know Texas
> 2. **Austin suburbs** - Same playbook, same state, still similar
> 3. **Phoenix suburbs** - Similar sprawl dynamics, tests playbook outside Texas
>
> We're not going to NYC until we've proven the suburban playbook works in 10 markets and have the resources to build a separate playbook for dense urban areas."

**Adjacency dimensions:**

| Dimension | Adjacent | Non-adjacent |
|-----------|----------|--------------|
| Geography | Dallas suburbs → Houston suburbs | Dallas suburbs → NYC |
| Category | Restaurants → Groceries | Restaurants → Legal services |
| Customer type | Families → Young professionals | Families → Enterprise |
| Use case | Dinner delivery → Lunch delivery | Dinner delivery → Catering |

**Sequencing framework:**

1. **First expansion:** Same playbook, different geography (prove repeatability)
2. **Second expansion:** Same geography, adjacent category (leverage existing users)
3. **Later:** New playbook for genuinely different markets (only with resources to do it right)

**Why it matters:**

Every expansion is an experiment. Adjacent markets let you isolate what you're testing - is it the geography, or is the playbook broken? Non-adjacent expansions change too many variables at once. You can't learn from failure if you don't know which variable caused it.
